/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.handler;

import cn.langpy.kotime.annotation.ComputeTime;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class ComputeTimeHandler {
    private static final Logger log = LoggerFactory.getLogger(ComputeTimeHandler.class);

    @Pointcut(value="@annotation(cn.langpy.kotime.annotation.ComputeTime)")
    public void preProcess() {
    }

    @Around(value="preProcess()")
    public Object doAroundCompute(ProceedingJoinPoint pjp) throws Throwable {
        ComputeTime computeTime = ((MethodSignature)pjp.getSignature()).getMethod().getAnnotation(ComputeTime.class);
        long begin = System.nanoTime();
        Object obj = pjp.proceed();
        long end = System.nanoTime();
        if ("chinese".equals(computeTime.value())) {
            log.info("\u8c03\u7528\u65b9\u6cd5={}\uff0c\u8017\u65f6={}\u6beb\u79d2", (Object)(pjp.getTarget().getClass().getName() + "." + pjp.getSignature().getName()), (Object)((end - begin) / 1000000L));
        } else {
            log.info("method={},runTime={}ms", (Object)(pjp.getTarget().getClass().getName() + "." + pjp.getSignature().getName()), (Object)((end - begin) / 1000000L));
        }
        return obj;
    }
}

