/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.config;

import cn.langpy.kotime.handler.RunTimeHandler;
import cn.langpy.kotime.model.KoTimeConfig;
import cn.langpy.kotime.util.Context;
import javax.annotation.PostConstruct;
import org.aopalliance.aop.Advice;
import org.springframework.aop.aspectj.AspectJExpressionPointcutAdvisor;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class DefaultConfig {
    @Value(value="${koTime.log.language:chinese}")
    private String logLanguage;
    @Value(value="${koTime.log.enable:false}")
    private Boolean logEnable;
    @Value(value="${koTime.time.threshold:800.0}")
    private Double timeThreshold;
    @Value(value="${koTime.pointcut:execution(* cn.langpy.kotime.controller.KoTimeController.*(..))}")
    private String pointcut;

    @PostConstruct
    public void function() {
        KoTimeConfig config = new KoTimeConfig();
        config.setLogEnable(this.logEnable);
        config.setLogLanguage(this.logLanguage);
        config.setTimeThreshold(this.timeThreshold);
        Context.setConfig(config);
    }

    @Bean
    public AspectJExpressionPointcutAdvisor configurabledvisor() {
        AspectJExpressionPointcutAdvisor advisor = new AspectJExpressionPointcutAdvisor();
        advisor.setExpression(this.pointcut);
        advisor.setAdvice((Advice)new RunTimeHandler());
        return advisor;
    }

    public Double getTimeThreshold() {
        return this.timeThreshold;
    }

    public void setTimeThreshold(Double timeThreshold) {
        this.timeThreshold = timeThreshold;
    }

    public String getLogLanguage() {
        return this.logLanguage;
    }

    public void setLogLanguage(String logLanguage) {
        this.logLanguage = logLanguage;
    }

    public Boolean getLogEnable() {
        return this.logEnable;
    }

    public void setLogEnable(Boolean logEnable) {
        this.logEnable = logEnable;
    }
}

