/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.controller;

import cn.langpy.kotime.model.ExceptionInfo;
import cn.langpy.kotime.model.ExceptionNode;
import cn.langpy.kotime.model.KoTimeConfig;
import cn.langpy.kotime.model.MethodInfo;
import cn.langpy.kotime.model.SystemStatistic;
import cn.langpy.kotime.service.GraphService;
import cn.langpy.kotime.util.Context;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/koTime"})
public class KoTimeController {
    @Value(value="${koTime.ui.template:freemarker}")
    private String showTemplate;

    @GetMapping
    public String index(Model model) {
        GraphService graphService = GraphService.getInstance();
        List<MethodInfo> methodList = graphService.getControllers();
        List<ExceptionNode> exceptionList = graphService.getExceptions();
        Collections.sort(methodList);
        model.addAttribute("methodList", methodList);
        model.addAttribute("exceptionList", exceptionList);
        SystemStatistic system = graphService.getRunStatistic();
        model.addAttribute("system", (Object)system);
        model.addAttribute("config", (Object)Context.getConfig());
        String template = "index-freemarker";
        if ("thymeleaf".equals(this.showTemplate)) {
            template = "index-thymeleaf";
        }
        return template;
    }

    @GetMapping(value={"/getConfig"})
    @ResponseBody
    public KoTimeConfig getConfig() {
        return Context.getConfig();
    }

    @GetMapping(value={"/getStatistic"})
    @ResponseBody
    public SystemStatistic getStatistic() {
        GraphService graphService = GraphService.getInstance();
        SystemStatistic system = graphService.getRunStatistic();
        return system;
    }

    @GetMapping(value={"/getApis"})
    @ResponseBody
    public List<MethodInfo> getApis() {
        GraphService graphService = GraphService.getInstance();
        List<MethodInfo> list = graphService.getControllers();
        Collections.sort(list);
        return list;
    }

    @GetMapping(value={"/getExceptions"})
    @ResponseBody
    public List<ExceptionNode> getExceptions() {
        GraphService graphService = GraphService.getInstance();
        List<ExceptionNode> exceptionList = graphService.getExceptions();
        return exceptionList;
    }

    @GetMapping(value={"/getTree"})
    @ResponseBody
    public MethodInfo getTree(String methodName) {
        GraphService graphService = GraphService.getInstance();
        return graphService.getTree(methodName);
    }

    @GetMapping(value={"/getMethodsByExceptionId"})
    @ResponseBody
    public List<ExceptionInfo> getMethodsByExceptionId(String exceptionId) {
        GraphService graphService = GraphService.getInstance();
        return graphService.getExceptionInfos(exceptionId);
    }

    @PostMapping(value={"/updateConfig"})
    @ResponseBody
    public boolean updateConfig(@RequestBody KoTimeConfig config) {
        KoTimeConfig koTimeConfig = Context.getConfig();
        if (config.getKotimeEnable() != null) {
            koTimeConfig.setKotimeEnable(config.getKotimeEnable());
        }
        if (config.getExceptionEnable() != null) {
            koTimeConfig.setExceptionEnable(config.getExceptionEnable());
        }
        if (config.getLogEnable() != null) {
            koTimeConfig.setLogEnable(config.getLogEnable());
        }
        if (config.getTimeThreshold() != null) {
            koTimeConfig.setTimeThreshold(config.getTimeThreshold());
        }
        return true;
    }
}

