/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.handler;

import cn.langpy.kotime.annotation.Auth;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.KoTimeNotLoginException;
import cn.langpy.kotime.util.KoUtil;
import java.lang.reflect.Method;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Aspect
@Component
public class AuthHandler {
    private static Logger log = Logger.getLogger(AuthHandler.class.toString());

    @Pointcut(value="@annotation(cn.langpy.kotime.annotation.Auth)")
    public void preProcess() {
    }

    @Around(value="preProcess()")
    public Object doAroundCompute(ProceedingJoinPoint pjp) throws Throwable {
        Method method = ((MethodSignature)pjp.getSignature()).getMethod();
        boolean needAuth = method.isAnnotationPresent(Auth.class);
        if (needAuth && Context.getConfig().getAuthEnable().booleanValue()) {
            if (!Context.getConfig().getEnable().booleanValue()) {
                throw new RuntimeException("no data to return,because kotime switch was closed!");
            }
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String token = request.getParameter("token");
            if (StringUtils.hasText((String)token)) {
                KoUtil.checkLogin(token);
            } else {
                throw new KoTimeNotLoginException("can not find login information for kotime,please login first!");
            }
        }
        return pjp.proceed();
    }
}

