/*
 * Decompiled with CFR 0.152.
 */
package cn.langpy.kotime.util;

import cn.langpy.kotime.model.ExceptionNode;
import cn.langpy.kotime.model.InvokedInfo;
import cn.langpy.kotime.model.MethodNode;
import cn.langpy.kotime.service.MethodNodeService;
import cn.langpy.kotime.util.Context;
import cn.langpy.kotime.util.MethodType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.stereotype.Controller;
import org.springframework.stereotype.Repository;
import org.springframework.stereotype.Service;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

public class Common {
    private static Logger log = Logger.getLogger(Common.class.toString());
    private static final List<Class<?>> baseTypes = Arrays.asList(Integer.class, Double.class, Float.class, Long.class, String.class, Boolean.class, MultipartFile.class, List.class, Map.class);
    private static final List<Class<?>> excludedTypes = Arrays.asList(HttpServletRequest.class, HttpServletResponse.class, Model.class);

    public static String getRoute(MethodInvocation pjp) {
        String[] methodRoute;
        Class<?> targetClass = pjp.getThis().getClass();
        String[] classRoute = Common.getRouteValue(targetClass);
        StringBuilder routes = new StringBuilder("");
        if (classRoute != null && classRoute.length > 0) {
            routes = new StringBuilder(classRoute[0]);
        }
        if ((methodRoute = Common.getRouteValue(pjp.getMethod())) == null || methodRoute.length == 0) {
            return null;
        }
        if (methodRoute[0].startsWith("/")) {
            routes.append(methodRoute[0]);
        } else {
            routes.append("/" + methodRoute[0]);
        }
        return routes.toString();
    }

    private static String[] getRouteValue(Class<?> targetClass) {
        RequestMapping methodAnnotationRequest = targetClass.getAnnotation(RequestMapping.class);
        if (methodAnnotationRequest != null) {
            return methodAnnotationRequest.value();
        }
        PostMapping methodAnnotationPost = targetClass.getAnnotation(PostMapping.class);
        if (methodAnnotationPost != null) {
            return methodAnnotationPost.value();
        }
        GetMapping methodAnnotationGet = targetClass.getAnnotation(GetMapping.class);
        if (methodAnnotationGet != null) {
            return methodAnnotationGet.value();
        }
        PutMapping methodAnnotationPut = targetClass.getAnnotation(PutMapping.class);
        if (methodAnnotationPut != null) {
            return methodAnnotationPut.value();
        }
        DeleteMapping methodAnnotationDelete = targetClass.getAnnotation(DeleteMapping.class);
        if (methodAnnotationDelete != null) {
            return methodAnnotationDelete.value();
        }
        return null;
    }

    private static String[] getRouteValue(Method method) {
        RequestMapping methodAnnotationRequest = method.getAnnotation(RequestMapping.class);
        if (methodAnnotationRequest != null) {
            return methodAnnotationRequest.value();
        }
        PostMapping methodAnnotationPost = method.getAnnotation(PostMapping.class);
        if (methodAnnotationPost != null) {
            return methodAnnotationPost.value();
        }
        GetMapping methodAnnotationGet = method.getAnnotation(GetMapping.class);
        if (methodAnnotationGet != null) {
            return methodAnnotationGet.value();
        }
        PutMapping methodAnnotationPut = method.getAnnotation(PutMapping.class);
        if (methodAnnotationPut != null) {
            return methodAnnotationPut.value();
        }
        DeleteMapping methodAnnotationDelete = method.getAnnotation(DeleteMapping.class);
        if (methodAnnotationDelete != null) {
            return methodAnnotationDelete.value();
        }
        return null;
    }

    public static MethodType getMethodType(MethodInvocation pjp) {
        Class<?> targetClass = pjp.getThis().getClass();
        if (targetClass.getAnnotation(Controller.class) != null || targetClass.getAnnotation(RestController.class) != null) {
            return MethodType.Controller;
        }
        if (targetClass.getAnnotation(Service.class) != null) {
            return MethodType.Service;
        }
        if (targetClass.getAnnotation(Repository.class) != null) {
            return MethodType.Dao;
        }
        String className = pjp.getMethod().getDeclaringClass().getName().toLowerCase();
        if (className.contains("controller")) {
            return MethodType.Controller;
        }
        if (className.contains("service")) {
            return MethodType.Service;
        }
        if (className.contains("dao") || className.contains("mapper") || className.contains("com.sun.proxy.$Proxy")) {
            return MethodType.Dao;
        }
        return MethodType.Others;
    }

    public static MethodType getMethodType(String className) {
        if ((className = className.toLowerCase()).contains("controller")) {
            return MethodType.Controller;
        }
        if (className.contains("service")) {
            return MethodType.Service;
        }
        if (className.contains("dao") || className.contains("mapper") || className.contains("com.sun.proxy.$Proxy")) {
            return MethodType.Dao;
        }
        return MethodType.Others;
    }

    public static void showLog(MethodNode current) {
        Common.showLog(current.getId(), current.getValue());
    }

    public static void showLog(String method, double value) {
        if ("chinese".equals(Context.getConfig().getLanguage())) {
            log.info("\u8c03\u7528\u65b9\u6cd5=" + method + "()\uff0c\u8017\u65f6=" + value + "\u6beb\u79d2");
        } else if ("english".equals(Context.getConfig().getLanguage())) {
            log.info("method=" + method + "(),runTime=" + value + "ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPramsStr(Parameter[] names, Object[] values) {
        String paramsKey = "-";
        if (names == null) {
            return paramsKey;
        }
        ArrayList<String> params = new ArrayList<String>();
        int namesLen = names.length;
        for (int i = 0; i < namesLen; ++i) {
            Field[] declaredFields;
            Object valuesI = values[i];
            if (Common.isEmpty(valuesI)) continue;
            Class<?> type = names[i].getType();
            if (baseTypes.contains(type)) {
                params.add(names[i].getName());
                continue;
            }
            if (excludedTypes.contains(type)) continue;
            for (Field field : declaredFields = valuesI.getClass().getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers())) continue;
                try {
                    field.setAccessible(true);
                    Object value = field.get(valuesI);
                    if (Common.isEmpty(value)) continue;
                    params.add(field.getName());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                finally {
                    field.setAccessible(false);
                }
            }
        }
        if (params.size() > 0) {
            paramsKey = String.join((CharSequence)"-", params);
        }
        return paramsKey;
    }

    public static boolean isEmpty(Object value) {
        return value == null || "".equals(value) || value instanceof String && ((String)value).trim().length() == 0;
    }

    public static InvokedInfo getInvokedInfo(MethodInvocation invocation, MethodNode parent, double runTime) {
        MethodNode current = MethodNodeService.getCurrentMethodNode(invocation, runTime);
        parent = Common.checkControllerParent(parent, current);
        InvokedInfo invokedInfo = new InvokedInfo();
        invokedInfo.setCurrent(current);
        invokedInfo.setParent(parent);
        invokedInfo.setNames(invocation.getMethod().getParameters());
        invokedInfo.setValues(invocation.getArguments());
        return invokedInfo;
    }

    public static InvokedInfo getInvokedInfoWithException(MethodInvocation invocation, MethodNode parent, Exception e, double runTime) {
        ExceptionNode exception = new ExceptionNode();
        exception.setName(e.getClass().getSimpleName());
        exception.setClassName(e.getClass().getName());
        exception.setMessage(e.getMessage() + "");
        exception.setId(exception.getClassName() + "." + exception.getName());
        MethodNode current = MethodNodeService.getCurrentMethodNode(invocation, runTime);
        InvokedInfo invokedInfo = new InvokedInfo();
        for (StackTraceElement stackTraceElement : e.getStackTrace()) {
            if (!stackTraceElement.getClassName().equals(current.getClassName())) continue;
            exception.setValue(stackTraceElement.getLineNumber());
            invokedInfo.setCurrent(current);
            parent = Common.checkControllerParent(parent, current);
            invokedInfo.setParent(parent);
            invokedInfo.setException(exception);
            invokedInfo.setNames(invocation.getMethod().getParameters());
            invokedInfo.setValues(invocation.getArguments());
            break;
        }
        return invokedInfo;
    }

    private static MethodNode checkControllerParent(MethodNode parent, MethodNode current) {
        if (current.getMethodType() == MethodType.Controller) {
            parent = new MethodNode();
            parent.setId("com.langpy.kotime.Controller.dispatch");
            parent.setClassName("Controller");
            parent.setMethodName("dispatch");
            parent.setName("Controller.dispatch");
            parent.setMethodType(MethodType.Dispatcher);
        }
        return parent;
    }
}

