/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.flyme;

import android.content.Context;
import cn.leancloud.LCException;
import cn.leancloud.LCFlymePushMessageReceiver;
import cn.leancloud.LCInstallation;
import cn.leancloud.LCLogger;
import cn.leancloud.LCManifestUtils;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.meizu.cloud.pushsdk.PushManager;
import com.meizu.cloud.pushsdk.util.MzSystemUtils;
import io.reactivex.Observer;

public class LCMixPushManager {
    private static final LCLogger LOGGER = LogUtil.getLogger(LCMixPushManager.class);
    public static final String MIXPUSH_PROFILE = "deviceProfile";
    public static String flymeDeviceProfile = "";
    public static int flymeMStatusBarIcon = 0;
    static Class flymePushReceiverClazz = LCFlymePushMessageReceiver.class;

    public static boolean registerFlymePush(Context context, String flymeId, String flymeKey, String profile) {
        return LCMixPushManager.registerFlymePush(context, flymeId, flymeKey, profile, null);
    }

    public static boolean registerFlymePush(Context context, String flymeId, String flymeKey, String profile, Class customizedReceiver) {
        if (null == context) {
            LCMixPushManager.printErrorLog("register error, context is null!");
            return false;
        }
        boolean result = false;
        if (!MzSystemUtils.isBrandMeizu((Context)context)) {
            LCMixPushManager.printErrorLog("register error, is not flyme phone!");
        } else {
            if (null != customizedReceiver) {
                flymePushReceiverClazz = customizedReceiver;
            }
            if (!LCMixPushManager.checkFlymeManifest(context)) {
                LCMixPushManager.printErrorLog("register error, mainifest is incomplete!");
            } else {
                flymeDeviceProfile = profile;
                PushManager.register((Context)context, (String)flymeId, (String)flymeKey);
                result = true;
                LOGGER.d("start register flyme push");
            }
        }
        return result;
    }

    public static boolean registerFlymePush(Context context, String flymeId, String flymeKey) {
        return LCMixPushManager.registerFlymePush(context, flymeId, flymeKey, "", null);
    }

    public static boolean registerFlymePush(Context context, String flymeId, String flymeKey, Class customizedReceiver) {
        return LCMixPushManager.registerFlymePush(context, flymeId, flymeKey, "", customizedReceiver);
    }

    public static void setFlymeMStatusbarIcon(int icon) {
        flymeMStatusBarIcon = icon;
    }

    public static void unRegisterMixPush() {
        LCInstallation installation = LCInstallation.getCurrentInstallation();
        String vendor = installation.getString("vendor");
        if (!StringUtil.isEmpty((String)vendor)) {
            installation.put("vendor", (Object)"lc");
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(LCException e) {
                    if (null != e) {
                        LCMixPushManager.printErrorLog("unRegisterMixPush error!");
                    } else {
                        LOGGER.d("Registration canceled successfully!");
                    }
                }
            }));
        }
    }

    private static boolean checkFlymeManifest(Context context) {
        boolean result = false;
        try {
            result = LCManifestUtils.checkReceiver((Context)context, (Class)flymePushReceiverClazz);
        }
        catch (Exception e) {
            LOGGER.d(e.getMessage());
        }
        return result;
    }

    private static void printErrorLog(String error) {
        if (!StringUtil.isEmpty((String)error)) {
            LOGGER.e(error);
        }
    }
}

