/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud;

import android.content.Context;
import cn.leancloud.LCException;
import cn.leancloud.LCInstallation;
import cn.leancloud.LCLogger;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import cn.leancloud.vivo.LCMixPushManager;
import com.vivo.push.model.UPSNotificationMessage;
import com.vivo.push.sdk.OpenClientPushMessageReceiver;
import io.reactivex.Observer;

public abstract class LCVIVOPushMessageReceiver
extends OpenClientPushMessageReceiver {
    private static final LCLogger LOGGER = LogUtil.getLogger(LCVIVOPushMessageReceiver.class);
    private final String VIVO_VENDOR = "vivo";

    public void onNotificationMessageClicked(Context context, UPSNotificationMessage msg) {
    }

    public void onReceiveRegId(Context var1, final String regId) {
        if (StringUtil.isEmpty((String)regId)) {
            LOGGER.e("received empty regId from VIVO server.");
        } else {
            String localProfile;
            LCInstallation installation = LCInstallation.getCurrentInstallation();
            if (!"vivo".equals(installation.getString("vendor"))) {
                installation.put("vendor", (Object)"vivo");
            }
            if (!regId.equals(installation.getString("registrationId"))) {
                installation.put("registrationId", (Object)regId);
            }
            String string = localProfile = null != (localProfile = installation.getString("deviceProfile")) ? localProfile : "";
            if (!localProfile.equals(LCMixPushManager.vivoDeviceProfile)) {
                installation.put("deviceProfile", (Object)LCMixPushManager.vivoDeviceProfile);
            }
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(LCException e) {
                    if (null != e) {
                        LOGGER.e("update installation(for vivo) error!", (Throwable)e);
                    } else {
                        LOGGER.d("vivo push registration successful! regId=" + regId);
                    }
                }
            }));
        }
    }
}

