/*
 * Decompiled with CFR 0.152.
 */
package cn.leancloud.vivo;

import android.app.Application;
import android.content.Context;
import cn.leancloud.LCException;
import cn.leancloud.LCInstallation;
import cn.leancloud.LCLogger;
import cn.leancloud.LeanCloud;
import cn.leancloud.callback.LCCallback;
import cn.leancloud.callback.SaveCallback;
import cn.leancloud.convertor.ObserverBuilder;
import cn.leancloud.utils.LogUtil;
import cn.leancloud.utils.StringUtil;
import com.vivo.push.IPushActionListener;
import com.vivo.push.PushClient;
import com.vivo.push.PushConfig;
import com.vivo.push.listener.IPushQueryActionListener;
import com.vivo.push.util.VivoPushException;
import io.reactivex.Observer;
import java.util.List;

public class LCMixPushManager {
    private static final LCLogger LOGGER = LogUtil.getLogger(LCMixPushManager.class);
    public static final String MIXPUSH_PROFILE = "deviceProfile";
    public static String vivoDeviceProfile = "";

    public static boolean registerVIVOPush(Application application, boolean agreePrivacyStatement) {
        return LCMixPushManager.registerVIVOPush(application, "", agreePrivacyStatement);
    }

    public static boolean registerVIVOPush(Application application, String profile, boolean agreePrivacyStatement) {
        vivoDeviceProfile = profile;
        if (null == application) {
            return false;
        }
        PushClient client = PushClient.getInstance((Context)application.getApplicationContext());
        try {
            client.checkManifest();
            if (!LCMixPushManager.isSupportVIVOPush((Context)application)) {
                LCMixPushManager.printErrorLog("current device doesn't support VIVO Push.");
                return false;
            }
            PushConfig config = new PushConfig.Builder().agreePrivacyStatement(agreePrivacyStatement).build();
            client.initialize(config);
            return true;
        }
        catch (VivoPushException ex) {
            LCMixPushManager.printErrorLog("register error, mainifest is incomplete! details=" + ex.getMessage());
            return false;
        }
    }

    public static void getRegistrationId(Context context, final LCCallback<String> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone(new LCException(9304, "context is invalid."));
            }
            return;
        }
        PushClient.getInstance((Context)context).getRegId(new IPushQueryActionListener(){

            public void onSuccess(String s) {
                if (null != callback) {
                    callback.internalDone((Object)s, null);
                }
            }

            public void onFail(Integer integer) {
                if (null != callback) {
                    callback.internalDone(new LCException(999, "PushClient error. code:" + integer));
                }
            }
        });
    }

    public static void turnOffVIVOPush(final LCCallback<Boolean> callback) {
        PushClient.getInstance((Context)LeanCloud.getContext()).turnOffPush(new IPushActionListener(){

            public void onStateChanged(int state) {
                if (null != callback) {
                    LCException exception = null;
                    if (0 != state) {
                        exception = new LCException(999, "VIVO server internal error, state=" + state);
                    }
                    callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                }
            }
        });
    }

    public static void turnOnVIVOPush(final LCCallback<Boolean> callback) {
        PushClient.getInstance((Context)LeanCloud.getContext()).turnOnPush(new IPushActionListener(){

            public void onStateChanged(int state) {
                if (null != callback) {
                    LCException exception = null;
                    if (0 != state) {
                        exception = new LCException(999, "VIVO server internal error, state=" + state);
                    }
                    callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                }
            }
        });
    }

    public static boolean isSupportVIVOPush(Context context) {
        PushClient client = PushClient.getInstance((Context)context);
        if (null == client) {
            return false;
        }
        return client.isSupport();
    }

    public static void bindVIVOAlias(Context context, String alias, final LCCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new LCException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).bindAlias(alias, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        LCException exception = null;
                        if (0 != state) {
                            exception = new LCException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static void unbindVIVOAlias(Context context, String alias, final LCCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new LCException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).unBindAlias(alias, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        LCException exception = null;
                        if (0 != state) {
                            exception = new LCException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static String getVIVOAlias(Context context) {
        if (null == context) {
            return null;
        }
        return PushClient.getInstance((Context)context).getAlias();
    }

    public static void setVIVOTopic(Context context, String topic, final LCCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new LCException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).setTopic(topic, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        LCException exception = null;
                        if (0 != state) {
                            exception = new LCException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static void delVIVOTopic(Context context, String alias, final LCCallback<Boolean> callback) {
        if (null == context) {
            if (null != callback) {
                callback.internalDone((Object)false, new LCException(142, "context is null"));
            }
        } else {
            PushClient.getInstance((Context)context).delTopic(alias, new IPushActionListener(){

                public void onStateChanged(int state) {
                    if (null == callback) {
                        LCException exception = null;
                        if (0 != state) {
                            exception = new LCException(999, "VIVO server internal error, state=" + state);
                        }
                        callback.internalDone((Object)(null == exception ? 1 : 0), exception);
                    }
                }
            });
        }
    }

    public static List<String> getVIVOTopics(Context context) {
        if (null == context) {
            return null;
        }
        return PushClient.getInstance((Context)context).getTopics();
    }

    public static void unRegisterMixPush() {
        LCInstallation installation = LCInstallation.getCurrentInstallation();
        String vendor = installation.getString("vendor");
        if (!StringUtil.isEmpty((String)vendor)) {
            installation.put("vendor", (Object)"lc");
            installation.saveInBackground().subscribe((Observer)ObserverBuilder.buildSingleObserver((SaveCallback)new SaveCallback(){

                public void done(LCException e) {
                    if (null != e) {
                        LCMixPushManager.printErrorLog("unRegisterMixPush error!");
                    } else {
                        LOGGER.d("Registration canceled successfully!");
                    }
                }
            }));
        }
    }

    private static void printErrorLog(String error) {
        if (!StringUtil.isEmpty((String)error)) {
            LOGGER.e(error);
        }
    }
}

