/*
 * Decompiled with CFR 0.152.
 */
package cn.letspay.payment.sdk.entity;

import cn.letspay.payment.sdk.entity.BaseResult;
import cn.letspay.payment.sdk.enumeration.ErrorCodeEnum;
import com.alibaba.fastjson.JSON;
import java.beans.ConstructorProperties;

public class CommonResult<T>
extends BaseResult {
    private Boolean success;
    private String errorCode;
    private String errorMsg;
    private T data;
    private Long timestamp;

    public static CommonResult success() {
        return CommonResult.success(null);
    }

    public static <T> CommonResult<T> success(T data) {
        return CommonResult.builder().success(true).data(data).timestamp(System.currentTimeMillis()).build();
    }

    public static <T> CommonResult<T> error(ErrorCodeEnum errorCodeEnum) {
        return CommonResult.error(errorCodeEnum.value(), errorCodeEnum.msg());
    }

    public static CommonResult error(String errorCode, String errorMsg) {
        return CommonResult.builder().success(false).errorCode(errorCode).errorMsg(errorMsg).timestamp(System.currentTimeMillis()).build();
    }

    public static <E> CommonResult<E> parse(String json, Class<E> entityCls) {
        CommonResult tempCommonResult = (CommonResult)JSON.parseObject((String)json, CommonResult.class);
        CommonResult<Object> commonResult = new CommonResult<Object>();
        commonResult.setSuccess(tempCommonResult.getSuccess());
        commonResult.setErrorCode(tempCommonResult.getErrorCode());
        commonResult.setErrorMsg(tempCommonResult.getErrorMsg());
        commonResult.setTimestamp(tempCommonResult.getTimestamp());
        if (entityCls == String.class) {
            commonResult.setData(tempCommonResult.getData());
        } else if (entityCls != Void.class) {
            commonResult.setData(JSON.toJavaObject((JSON)((JSON)tempCommonResult.getData()), entityCls));
        }
        return commonResult;
    }

    public static <T> CommonResultBuilder<T> builder() {
        return new CommonResultBuilder();
    }

    public Boolean getSuccess() {
        return this.success;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public T getData() {
        return this.data;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public CommonResult() {
    }

    @ConstructorProperties(value={"success", "errorCode", "errorMsg", "data", "timestamp"})
    public CommonResult(Boolean success, String errorCode, String errorMsg, T data, Long timestamp) {
        this.success = success;
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
        this.data = data;
        this.timestamp = timestamp;
    }

    public static class CommonResultBuilder<T> {
        private Boolean success;
        private String errorCode;
        private String errorMsg;
        private T data;
        private Long timestamp;

        CommonResultBuilder() {
        }

        public CommonResultBuilder<T> success(Boolean success) {
            this.success = success;
            return this;
        }

        public CommonResultBuilder<T> errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public CommonResultBuilder<T> errorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
            return this;
        }

        public CommonResultBuilder<T> data(T data) {
            this.data = data;
            return this;
        }

        public CommonResultBuilder<T> timestamp(Long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public CommonResult<T> build() {
            return new CommonResult<T>(this.success, this.errorCode, this.errorMsg, this.data, this.timestamp);
        }

        public String toString() {
            return "CommonResult.CommonResultBuilder(success=" + this.success + ", errorCode=" + this.errorCode + ", errorMsg=" + this.errorMsg + ", data=" + this.data + ", timestamp=" + this.timestamp + ")";
        }
    }
}

