/*
 * Decompiled with CFR 0.152.
 */
package cn.letspay.payment.sdk.service;

import cn.letspay.payment.sdk.entity.BaseParam;
import cn.letspay.payment.sdk.entity.CommonResult;
import cn.letspay.payment.sdk.entity.attr.CashierAsyncNotificationAttr;
import cn.letspay.payment.sdk.entity.attr.CashierOrderAttr;
import cn.letspay.payment.sdk.entity.attr.CashierOrderIdAttr;
import cn.letspay.payment.sdk.entity.attr.EnterpriseSignAttr;
import cn.letspay.payment.sdk.entity.attr.IndividualSignAttr;
import cn.letspay.payment.sdk.entity.attr.RefundAsyncNotificationAttr;
import cn.letspay.payment.sdk.entity.attr.RefundAttr;
import cn.letspay.payment.sdk.entity.impl.param.BankCardManagementLinkGettingParam;
import cn.letspay.payment.sdk.entity.impl.param.CashierLinkGettingParam;
import cn.letspay.payment.sdk.entity.impl.param.CashierOrderCreatingParam;
import cn.letspay.payment.sdk.entity.impl.param.QrCodeSvgCreatingParam;
import cn.letspay.payment.sdk.entity.impl.param.RefundApplyingParam;
import cn.letspay.payment.sdk.enumeration.ErrorCodeEnum;
import cn.letspay.payment.sdk.exception.SignExpiredException;
import cn.letspay.payment.sdk.exception.SignFailedException;
import cn.letspay.payment.sdk.exception.SignInspectionFailedException;
import cn.letspay.payment.sdk.util.SignUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class PaymentService {
    private static final Logger log = LoggerFactory.getLogger(PaymentService.class);
    @Value(value="${letspay.host}")
    private String paymentHost = "https://cashier.letspay.cn";
    private final RestTemplate REST_TEMPLATE = new RestTemplate((ClientHttpRequestFactory)new HttpComponentsClientHttpRequestFactory());

    public PaymentService() {
        this.REST_TEMPLATE.getMessageConverters().set(1, new StringHttpMessageConverter(StandardCharsets.UTF_8));
    }

    public PaymentService(String paymentHost) {
        this();
        this.paymentHost = paymentHost;
    }

    public CommonResult<CashierOrderAttr> createCashierOrder(CashierOrderCreatingParam param) {
        String uri = "/individual/v1/cashiers/order";
        JSONObject paramJson = this.sign(param);
        CommonResult<CashierOrderAttr> result = this.execute(uri, HttpMethod.POST, paramJson, CashierOrderAttr.class);
        if (result.getSuccess().booleanValue()) {
            result.getData().setSign(paramJson.getString("sign"));
            CashierLinkGettingParam p = CashierLinkGettingParam.builder().orderId(result.getData().getOrderId()).build();
            p.setPaymentAppId(param.getPaymentAppId());
            p.setEnterprisePrivateKey(param.getEnterprisePrivateKey());
            p.setUserNo(param.getUserNo());
            p.setName(param.getName());
            p.setMobile(param.getMobile());
            p.setIdentityNo(param.getIdentityNo());
            p.setWechatOpenId(param.getWechatOpenId());
            String link = this.getCashierLink(p);
            result.getData().setCashierLink(link);
        }
        return result;
    }

    public String getCashierLink(CashierLinkGettingParam param) {
        String uri = "/cashier_payRent";
        return this.generateLink(uri, param);
    }

    public String getBankCardManagementLink(BankCardManagementLinkGettingParam param) {
        String uri = "/cashier_bankList";
        return this.generateLink(uri, param);
    }

    public CommonResult<CashierOrderIdAttr> getCashierOrderId(String requestBody) {
        CashierAsyncNotificationAttr attr = (CashierAsyncNotificationAttr)JSON.parseObject((String)requestBody, CashierAsyncNotificationAttr.class);
        return CommonResult.success(CashierOrderIdAttr.builder().orderId(attr.getOrderId()).orderNo(attr.getOrderNo()).randomId(attr.getRandomId()).customData(attr.getCustomData()).build());
    }

    public CommonResult<CashierAsyncNotificationAttr> receiveCashierAsyncNotification(String requestBody, String paymentPublicKey) {
        return this.receiveAsyncNotification(requestBody, paymentPublicKey, CashierAsyncNotificationAttr.class);
    }

    public CommonResult<RefundAttr> applyRefund(RefundApplyingParam param) {
        String uri = "/enterprise/v1/refunds";
        JSONObject paramJson = this.signEnt(param);
        CommonResult<RefundAttr> result = this.execute(uri, HttpMethod.POST, paramJson, RefundAttr.class);
        return result;
    }

    public CommonResult<RefundAsyncNotificationAttr> receiveRefundAsyncNotification(String requestBody, String paymentPublicKey) {
        return this.receiveAsyncNotification(requestBody, paymentPublicKey, RefundAsyncNotificationAttr.class);
    }

    public CommonResult<String> createQrCodeSvg(QrCodeSvgCreatingParam param) {
        String uri = "/individual/v1/cashiers/qr_code/svg";
        CommonResult<String> result = this.execute(uri, HttpMethod.POST, param, String.class);
        return result;
    }

    private <A> CommonResult<A> receiveAsyncNotification(String requestBody, String paymentPublicKey, Class<A> attrCls) {
        CommonResult<Object> result;
        try {
            JSONObject jsonObject = this.inspectSign(requestBody, paymentPublicKey);
            Object attr = JSON.toJavaObject((JSON)jsonObject, attrCls);
            result = CommonResult.success(attr);
        }
        catch (SignExpiredException see) {
            result = CommonResult.error(ErrorCodeEnum.SIGN_EXPIRED);
        }
        catch (SignInspectionFailedException sife) {
            result = CommonResult.error(ErrorCodeEnum.SIGN_INSPECTION_FAILED);
        }
        return result;
    }

    private <A> CommonResult<A> execute(String uri, HttpMethod method, Object paramJson, Class<A> attrCls) {
        String json;
        String url = this.paymentHost + uri;
        HttpHeaders headers = new HttpHeaders();
        headers.set("Connection", "Close");
        headers.add("Content-Type", "application/json; charset=utf-8");
        headers.add("Accept", "application/json");
        HttpEntity httpEntity = new HttpEntity((Object)JSON.toJSONString((Object)paramJson), (MultiValueMap)headers);
        try {
            ResponseEntity resp = this.REST_TEMPLATE.exchange(url, method, httpEntity, String.class, new Object[0]);
            json = (String)resp.getBody();
        }
        catch (HttpClientErrorException hcee) {
            log.warn(hcee.getMessage());
            json = hcee.getResponseBodyAsString();
        }
        return CommonResult.parse(json, attrCls);
    }

    private String generateLink(String uri, BaseParam param) {
        JSONObject jsonObject = this.sign(param);
        String queryString = this.jsonObjectToQueryString(jsonObject);
        String url = this.paymentHost + uri + "?" + queryString;
        return url;
    }

    private JSONObject sign(BaseParam param) {
        JSONObject jsonObject = JSON.parseObject((String)param.toJson());
        IndividualSignAttr individualSign = IndividualSignAttr.builder().userNo(param.getUserNo()).identityNo(param.getIdentityNo()).name(param.getName()).mobile(param.getMobile()).wechatOpenId(param.getWechatOpenId()).build();
        individualSign.setAppId(param.getPaymentAppId());
        individualSign.setTimestamp(System.currentTimeMillis());
        try {
            String cipherStr = param.getPaymentAppId() + "_" + param.getIdentityNo() + "_" + param.getMobile() + "_" + param.getName() + "_" + param.getUserNo() + "_" + param.getWechatOpenId() + "_" + individualSign.getTimestamp();
            byte[] cipherText = cipherStr.getBytes(StandardCharsets.UTF_8);
            PrivateKey privateKey = SignUtil.getPrivateKey(param.getEnterprisePrivateKey());
            byte[] bytes = SignUtil.sign(cipherText, privateKey);
            individualSign.setSign(bytes);
            String signPlaintext = JSON.toJSONString((Object)individualSign);
            String sign = Base64.getEncoder().encodeToString(signPlaintext.getBytes());
            jsonObject.put("sign", (Object)sign);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SignFailedException(e);
        }
        return jsonObject;
    }

    private JSONObject signEnt(RefundApplyingParam param) {
        JSONObject jsonObject = JSON.parseObject((String)param.toJson());
        EnterpriseSignAttr enterpriseSignAttr = EnterpriseSignAttr.builder().appId(param.getPaymentAppId()).timestamp(System.currentTimeMillis()).build();
        try {
            String cipherStr = param.getPaymentAppId() + "_" + enterpriseSignAttr.getTimestamp();
            byte[] cipherText = cipherStr.getBytes(StandardCharsets.UTF_8);
            PrivateKey privateKey = SignUtil.getPrivateKey(param.getEnterprisePrivateKey());
            byte[] bytes = SignUtil.sign(cipherText, privateKey);
            enterpriseSignAttr.setSign(bytes);
            String signPlaintext = JSON.toJSONString((Object)enterpriseSignAttr);
            String sign = Base64.getEncoder().encodeToString(signPlaintext.getBytes());
            jsonObject.put("sign", (Object)sign);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SignFailedException(e);
        }
        return jsonObject;
    }

    private JSONObject inspectSign(String data, String paymentPublicKey) {
        JSONObject jsonObject;
        try {
            PublicKey publicKey;
            jsonObject = JSON.parseObject((String)data);
            byte[] sign = jsonObject.getBytes("sign");
            jsonObject.remove((Object)"sign");
            ArrayList<String> list = new ArrayList<String>();
            Set entries = jsonObject.entrySet();
            for (Map.Entry entry : entries) {
                list.add((String)entry.getKey() + "=" + entry.getValue());
            }
            list.sort(String::compareTo);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < list.size(); ++i) {
                String str = (String)list.get(i);
                sb.append(str);
                if (i >= list.size() - 1) continue;
                sb.append("&");
            }
            byte[] cipherText = sb.toString().getBytes(StandardCharsets.UTF_8);
            boolean flag = SignUtil.verify(cipherText, publicKey = SignUtil.getPublicKey(paymentPublicKey), sign);
            if (!flag) {
                throw new SignInspectionFailedException();
            }
            Long timestamp = jsonObject.getLong("signTimestamp");
            Long signValidity = jsonObject.getLong("signValidity");
            long expiryTimestamp = timestamp + signValidity;
            if (expiryTimestamp <= System.currentTimeMillis()) {
                throw new SignExpiredException();
            }
        }
        catch (SignExpiredException | SignInspectionFailedException se) {
            throw se;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SignInspectionFailedException();
        }
        return jsonObject;
    }

    private String jsonObjectToQueryString(JSONObject jsonObject) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : jsonObject.entrySet()) {
            try {
                sb.append(entry.getKey()).append("=").append(URLEncoder.encode(entry.getValue() + "", "UTF-8")).append("&");
            }
            catch (UnsupportedEncodingException uee) {
                log.error(uee.getMessage(), (Throwable)uee);
                throw new RuntimeException(uee);
            }
        }
        String qs = sb.toString();
        qs = qs.substring(0, qs.length() - 1);
        return qs;
    }
}

