#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Data
@Configuration
@ConfigurationProperties(prefix = "${parentArtifactId}")
public class AppProperties {
    private Security security;
    private boolean enableCfToken = true;

    @Data
    public static class Security {
        private Authentication authentication;
        @Data
        public static class Authentication {
            private Jwt jwt;

            @Data
            public static class Jwt {
                private String base64Secret;
                private long tokenValidityInSeconds;
                private long tokenValidityInSecondsForRememberMe;
            }
        }
    }
}
