#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.config;

import lombok.extern.slf4j.Slf4j;
import org.redisson.spring.data.connection.RedissonConnectionFactory;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.data.redis.cache.RedisCacheManager;

@EnableCaching
@Configuration
@Slf4j
public class CacheConfiguration {

    @Profile("!dev")
    @Bean
    public CacheManager redisCacheManager(RedissonConnectionFactory factory) {
        return RedisCacheManager.builder(factory).build();
    }


    @Profile("dev")
    @Bean
    public CacheManager simpleCacheManager() {
        return new SimpleCacheManager();
    }
}
