#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.config;

import ${package}.security.DbJwtGrantedAuthoritiesConverter;
import ${package}.security.DynamicExpireJwtDecoder;
import ${package}.security.UserPermissionService;
import com.nimbusds.jose.jwk.source.ImmutableSecret;
import com.nimbusds.jose.util.Base64;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.jwt.*;
import org.springframework.security.oauth2.server.resource.authentication.JwtAuthenticationConverter;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

import java.time.Duration;

import static ${package}.security.SecurityUtils.JWT_ALGORITHM;

@Slf4j
@Configuration
@RequiredArgsConstructor
public class SecurityJwtConfiguration {
    private final AppProperties appProperties;

    @Bean
    public JwtDecoder jwtDecoder(UserDetailsService userDetailsService) {
        var decoder = NimbusJwtDecoder.withSecretKey(getSecretKey()).macAlgorithm(JWT_ALGORITHM).build();
        decoder.setJwtValidator(new JwtTimestampValidator(Duration.ofSeconds(1L)));
        return new DynamicExpireJwtDecoder(decoder, userDetailsService);
    }

    @Bean
    public JwtEncoder jwtEncoder() {
        return new NimbusJwtEncoder(new ImmutableSecret<>(getSecretKey()));
    }

    @Bean
    public JwtAuthenticationConverter jwtAuthenticationConverter(UserPermissionService userPermissionService) {
        var grantedAuthoritiesConverter = new DbJwtGrantedAuthoritiesConverter(userPermissionService);

        JwtAuthenticationConverter jwtAuthenticationConverter = new JwtAuthenticationConverter();
        jwtAuthenticationConverter.setJwtGrantedAuthoritiesConverter(grantedAuthoritiesConverter);
        return jwtAuthenticationConverter;
    }

    private SecretKey getSecretKey() {
        byte[] keyBytes = Base64.from(appProperties.getSecurity().getAuthentication().getJwt().getBase64Secret()).decode();
        return new SecretKeySpec(keyBytes, 0, keyBytes.length, JWT_ALGORITHM.getName());
    }
}
