#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.config;

import cn.hutool.json.JSONUtil;
import ${package}.web.vo.Result;
import jakarta.annotation.Nonnull;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;


@ControllerAdvice
public class WrapperResponseBodyAdvice implements ResponseBodyAdvice<Object> {
    @Override
    public boolean supports(@Nonnull MethodParameter returnType,
                            @Nonnull Class<? extends HttpMessageConverter<?>> converterType) {
        if (VoidMessageConverter.class.equals(converterType)) {
            return true;
        }
        if (Result.class.isAssignableFrom(returnType.getParameterType())) {
            return false;
        }
        return converterType.equals(MappingJackson2HttpMessageConverter.class)
                || converterType.equals(StringHttpMessageConverter.class);
    }

    @Override
    public Object beforeBodyWrite(Object body, @Nonnull MethodParameter returnType,
                                  @Nonnull MediaType selectedContentType,
                                  @Nonnull Class<? extends HttpMessageConverter<?>> selectedConverterType,
                                  @Nonnull ServerHttpRequest request, @Nonnull ServerHttpResponse response) {
        if (body != null && Result.class.isAssignableFrom(body.getClass())) {
            return body;
        }
        if (selectedConverterType.equals(StringHttpMessageConverter.class)) {
            return JSONUtil.toJsonStr(Result.ok(body));
        }
        if (selectedConverterType.equals(VoidMessageConverter.class)) {
            return Result.ok();
        }
        return Result.ok(body);
    }
}
