#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.queue;

import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import jakarta.annotation.Resource;

/**
 * 应用启动完毕后触发一次所有队列的消费
 *
 * @author yujiaxin
 */
@Order(Ordered.HIGHEST_PRECEDENCE + 1)
@Slf4j
@Component
public class OnceQueueConsumer implements ApplicationRunner {
    @Resource
    private QueueService queueService;

    @Override
    public void run(ApplicationArguments args) {
        for (DelayedQueue<?> delayedQueue : queueService.getAllQueue()) {
            delayedQueue.consume();
        }
    }
}
