#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.util;

public class FileSizeFormatter {

    public static String formatFileSize(long bytes) {
        if (bytes < 1024) return bytes + " B";
        int exp = (int) (Math.log(bytes) / Math.log(1024));
        String units = "KMGTPE";
        double value = bytes / Math.pow(1024, exp);
        return String.format("%.2f %sB", value, units.charAt(exp - 1));
    }
}
