#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package};

import com.baomidou.mybatisplus.generator.FastAutoGenerator;
import com.baomidou.mybatisplus.generator.engine.FreemarkerTemplateEngine;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.test.context.SpringBootTest;


@Disabled
@SpringBootTest
class ApplicationTests {
    @Value("${symbol_dollar}{spring.datasource.url}")
    private String url;
    @Value("${symbol_dollar}{spring.datasource.username}")
    private String username;
    @Value("${symbol_dollar}{spring.datasource.password}")
    private String password;

    @Test
    void generator() {
        FastAutoGenerator.create(url, username, password)
                .globalConfig(builder -> builder
                        .author("yujiaxin")
                        .outputDir("./src/main/java")
                        .commentDate("yyyy-MM-dd")
                )
                .packageConfig(builder -> builder
                        .parent("${package}.customer")
                        .entity("entity")
                        .mapper("mapper")
                        .xml("mapper.xml")
                )
                .strategyConfig(builder -> builder
                        .addInclude("customer_config")
                        .entityBuilder()
                        .enableLombok()
                        .serviceBuilder()
                        .disableService()
                        .disableServiceImpl()
                        .controllerBuilder()
                        .disable()
                )
                .templateEngine(new FreemarkerTemplateEngine())
                .execute();
    }
}
