import { http } from '@/utils/http'
import { request as __request } from '@/api/generated/apis/core/request'
import { CancelablePromise } from '@/api/generated/apis/core/CancelablePromise'
import { BaseHttpRequest } from '@/api/generated/apis/core/BaseHttpRequest'
import { ApiRequestOptions } from '@/api/generated/apis/core/ApiRequestOptions'
import type { OpenAPIConfig } from '@/api/generated/apis/core/OpenAPI'
import { RestApi } from '@/api/generated/apis/RestApi'

class HttpRequest extends BaseHttpRequest {
  axiosInstance = http.getAxiosInstance()

  constructor(config: OpenAPIConfig) {
    super(config)
  }

  public override request<T>(options: ApiRequestOptions): CancelablePromise<T> {
    return __request(this.config, options, this.axiosInstance)
  }
}

const shApi = new RestApi(
  {},
  HttpRequest
)

export { shApi }
