import { AccountStatus } from '@/api/generated/api';
import { shallowReactive } from 'vue';
import { useRoute, useRouter } from 'vue-router';

export const AccountPlatformText = {
  IOS: '苹果个人',
  SMB_IOS: '苹果商业',
  ANDROID: '安卓个人',
  SMB_ANDROID: '安卓商业',
};

export const AccountStatusColorType = {
  [AccountStatus.NEW]: 'primary',
  [AccountStatus.NORMAL]: 'primary',
  [AccountStatus.ONLINE]: 'success',
  [AccountStatus.OFFLINE]: 'info',
  [AccountStatus.ABNORMAL]: 'warning',
  [AccountStatus.BANNED]: 'danger',
} as const;

export const createSearchModel = <T extends Record<string, any>>(
  obj: T,
  converter: Record<string, Function> = {}
) => {
  const route = useRoute();
  const model = shallowReactive(obj);
  for (const [key, val] of Object.entries(route.query)) {
    if (Object.hasOwn(model, key)) {
      // @ts-ignore
      model[key] = converter[key] ? converter[key](val) : val;
    }
  }
  const router = useRouter();
  return [
    model,
    /** syncModelToUrl */
    () => {
      router.push({ query: model });
    },
  ] as const;
};

export function triggerBrowserDownload(
  blobParts: BlobPart[],
  fileName: string,
  type?: string
) {
  const blob = new Blob(blobParts, { type });
  const el = document.createElement('a');
  el.href = URL.createObjectURL(blob);
  el.download = fileName;
  el.click();
  URL.revokeObjectURL(el.href);
}

// export function parsePhoneNumber(phoneNumberStr: string) {
//   try {
//     if (!phoneNumberStr.startsWith("+")) {
//       phoneNumberStr = "+" + phoneNumberStr;
//     }
//     const phoneNumber = parsePhoneNumberWithError(phoneNumberStr);
//     const result = {
//       iso_3166_alpha_2: phoneNumber.country,
//       cc: +phoneNumber.countryCallingCode,
//       ndc: "",
//       sn: phoneNumber.nationalNumber,
//     };
//     const matchResult = phoneNumber.formatNational().match(/^\((\d+)\)(.+)/);
//     if (matchResult) {
//       result.ndc = result[1];
//       result.sn = result[2].replace(/\s|-/g, "");
//     }
//     return [result] as const;
//   } catch (error) {
//     return [, error] as [undefined, Error];
//   }
// }

export function blobToBase64(blob: Blob) {
  const reader = new FileReader();
  const { promise, resolve } = Promise.withResolvers<string>();
  reader.onload = event => {
    resolve(event.target.result as string);
  };
  reader.readAsDataURL(blob);
  return promise;
}

export async function convertImageToJpg(blob: Blob, width = 50, height = 50) {
  const canvas = new OffscreenCanvas(width, height);
  const ctx = canvas.getContext('2d');
  const imageBitmap = await createImageBitmap(blob);
  ctx.drawImage(imageBitmap, 0, 0, width, height);
  return await canvas.convertToBlob({ type: 'image/jpeg' });
}

// export function parseNumbersFromText(text: string) {
//   const numberSet = new Set<string>();
//   for (let str of text.trim().split("\n")) {
//     str = str.replace(/^\D+/, "").replace(/\D+$/, "");
//     if (/^\d{3,15}$/.test(str)) {
//       numberSet.add(str);
//     }
//   }
//   return numberSet;
// }
