import {body, endpoint, request, response, DateTime, headers, Int32} from "spot-liangjihua";
import {ApiResult} from "../base-model";

/**
 * 获取授权 token 接口
 */
@endpoint({
    path: '/auth/authenticate',
    method: 'POST',
    tags: [
        'authenticate'
    ]
})
class Authorize {
    @request
    request(
        @body() body: LoginRequest
    ){}

    @response({status: 200})
    response(
        @body() body: LoginResponse
    ){}
}

/**
 * refresh token 接口
 */
@endpoint({
  path: '/auth/refreshToken',
  method: 'POST',
  tags: [
    'authenticate'
  ]
})
class RefreshToken {
  @request
  request(
    @headers
      headers: {
      "Authorization": string;
    }
  ){}

  @response({status: 200})
  response(
    @body() body: LoginResponse
  ){}
}

/**
 * 授权token请求
 */
interface LoginRequest {
    /**
     * 用户名
     */
    username: string;
    /**
     * 密码
     */
    password: string;
    /**
     * cloudflare 验证码
     */
    token: string;
}

/**
 * 授权token响应
 */
interface LoginResponse extends ApiResult {
    data: LoginData;
}

/**
 * login data
 */
interface LoginData {
  /**
   * accessToken
   */
  accessToken: string;
  /**
   * refreshToken
   */
  refreshToken: string;
  /**
   * accessToken 过期时间
   */
  expires: DateTime;
}

/**
 * 登陆用户信息
 */
@endpoint({
  path: '/auth/userInfo',
  method: 'POST',
  tags: [
    'authenticate'
  ]
})
class UserInfo {
  @request
  request(){}

  @response({status: 200})
  response(
    @body() body: UserInfoResponse
  ){}
}
interface UserInfoResponse extends ApiResult {
  data: UserInfoData
}

interface UserInfoData {
  /** 头像 */
  avatar: string;
  /** 用户名 */
  username: string;
  /** 昵称 */
  nickname?: string;
  /** 权限 */
  permissions?: string[];
  /** 类型 0，超级管理员，1，管理员，2，客户 */
  type: Int32;
  /** 账号过期时间*/
  expireTime?: DateTime;
}
