#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.config;

import ${package}.exception.BizException;
import ${package}.util.FileSizeFormatter;
import ${package}.web.vo.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AccountStatusException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.multipart.MaxUploadSizeExceededException;

@Slf4j
@RestControllerAdvice
public class RestResponseEntityExceptionHandler{


    /*
    what to handle watch here:
org.springframework.web.servlet.mvc.method.annotation.ResponseEntityExceptionHandler
     */
    @ExceptionHandler({ Exception.class })
    public ResponseEntity<Result<?>> handleException(Exception ex, WebRequest request) {
        log.error("服务器异常", ex);
        return new ResponseEntity<>(Result.fail("请求处理异常"), HttpStatus.OK);
    }


    @ExceptionHandler({ BizException.class })
    public ResponseEntity<Result<?>> handleException(BizException ex, WebRequest request) {
        log.error("请求处理异常", ex);
        return new ResponseEntity<>(Result.fail(ex.getMessage()), HttpStatus.OK);
    }


    @ExceptionHandler({ MaxUploadSizeExceededException.class })
    public ResponseEntity<Result<?>> handleException(MaxUploadSizeExceededException ex) {
        String s = FileSizeFormatter.formatFileSize(ex.getMaxUploadSize());
        log.error("上传文件超过：{}", s, ex);
        Result<?> fail = Result.fail("上传文件大小不能超过：%s".formatted(s));
        return new ResponseEntity<>(fail, HttpStatus.OK);
    }


    @ExceptionHandler({ BadCredentialsException.class })
    public ResponseEntity<Result<?>> handleException(BadCredentialsException ex, WebRequest request) {
        log.error("账号密码错误", ex);
        return new ResponseEntity<>(Result.fail(ex.getMessage()), HttpStatus.OK);
    }

    @ExceptionHandler({ AccountStatusException.class })
    public ResponseEntity<Result<?>> handleException(AccountStatusException ex, WebRequest request) {
        return new ResponseEntity<>(Result.fail(ex.getMessage()), HttpStatus.OK);
    }

    @ExceptionHandler({ BadJwtException.class })
    public ResponseEntity<Result<?>> handleException(BadJwtException ex, WebRequest request) {
        log.error("jwt token 认证异常", ex);
        return new ResponseEntity<>(Result.fail("请求用户非法或已过期"), HttpStatus.OK);
    }
}