#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.queue.impl;

import ${package}.queue.DelayedQueue;
import ${package}.queue.QueueService;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class JavaQueueService implements QueueService {
    private final Map<String, DelayedQueue<?>> queueMap = new ConcurrentHashMap<>();
    @SuppressWarnings("unchecked")
    @Override
    public <T> DelayedQueue<T> getDelayedQueue(String queueName) {
        return (DelayedQueue<T>) queueMap.computeIfAbsent(queueName, JavaDelayedQueue::new);
    }

    @Override
    public List<DelayedQueue<?>> getAllQueue() {
        return new ArrayList<>(queueMap.values());
    }
}
