#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.security;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.oauth2.jwt.Jwt;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 从持久化存储中恢复 jwt token 关联的用户所拥有的权限
 */
@Slf4j
@RequiredArgsConstructor
public class DbJwtGrantedAuthoritiesConverter implements Converter<Jwt, Collection<GrantedAuthority>> {
    private final UserPermissionService userPermissionService;
    @Override
    public Collection<GrantedAuthority> convert(@NonNull Jwt jwt) {
        String subject = jwt.getSubject();
        Set<String> permissions = userPermissionService.loadPermissionsByUsername(subject);
        if (permissions == null) {
            return Collections.emptyList();
        }
        return permissions.stream().map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }
}
