#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.security;

import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.oauth2.jwt.BadJwtException;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.oauth2.jwt.JwtException;

public class DynamicExpireJwtDecoder implements JwtDecoder{
    private final JwtDecoder decoder;
    private final UserDetailsService userDetailsService;

    public DynamicExpireJwtDecoder(JwtDecoder decoder, UserDetailsService userDetailsService) {
        this.decoder = decoder;
        this.userDetailsService = userDetailsService;
    }

    @Override
    public Jwt decode(String token) throws JwtException {
        Jwt jwt = decoder.decode(token);
        var username = jwt.getSubject();
        var user = userDetailsService.loadUserByUsername(username);
        if (user.isAccountNonExpired() && user.isEnabled()) {
            return jwt;
        }
        throw new BadJwtException("账号已过期");
    }
}
