import {body, endpoint, request, response, Int64, DateTime, String} from "spot-liangjihua";
import {ApiResult} from "../base-model";


/**
 * 新建管理员
 */
@endpoint({
  path: '/adminUser/create',
  method: 'POST',
  tags: [
    'adminUser'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:user:create')")`
    ]
  }
})
class CreateAdminUser {
  @request
  request(
    @body() body: CreateAdminUserRequest
  ){}

  @response({status: 200})
  response(
    @body() body: CreateAdminUserResponse
  ){}
}

interface CreateAdminUserRequest {
  /** 用户名 */
  username: string;
  /** 密码 */
  password?: string;
  /** 昵称 */
  nickname: string;
  /** 头像 */
  avatar: string;
  /** 是否超管 */
  isSuperAdmin: boolean;
  /** 是否启用 */
  isActive: boolean;
  /** 角色 */
  roles?: Int64[];
}

interface CreateAdminUserResponse extends ApiResult {
  data: CreateAdminUserData
}

interface CreateAdminUserData {
  /** id */
  id: Int64;
}

/**
 * 更新管理员
 */
@endpoint({
  path: '/adminUser/update',
  method: 'POST',
  tags: [
    'adminUser'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:user:update')")`
    ]
  }
})
class UpdateAdminUser {
  @request
  request(
    @body() body: UpdateAdminUserRequest
  ){}

  @response({status: 200})
  response(
    @body() body: UpdateAdminUserResponse
  ){}
}

interface UpdateAdminUserRequest {
  /** id */
  id: Int64;
  /** 密码 */
  password?: string;
  /** 昵称 */
  nickname: string;
  /** 头像 */
  avatar: string;
  /** 是否超管 */
  isSuperAdmin: boolean;
  /** 是否启用 */
  isActive: boolean;
  /** 角色 */
  roles?: Int64[];
}

interface UpdateAdminUserResponse extends ApiResult {
  data: UpdateAdminUserData
}

interface UpdateAdminUserData {
  /** id */
  id: Int64;
}

/**
 * 读取管理员
 */
@endpoint({
  path: '/adminUser/read',
  method: 'POST',
  tags: [
    'adminUser'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:user:read')")`
    ]
  }
})
class ReadAdminUser {
  @request
  request(
    @body() body: ReadAdminUserRequest
  ){}

  @response({status: 200})
  response(
    @body() body: ReadAdminUserResponse
  ){}
}

interface ReadAdminUserRequest {
  /** id */
  id: Int64;
}

interface ReadAdminUserResponse extends ApiResult {
  data: ReadAdminUserData
}

interface ReadAdminUserData {
  /** id */
  id: Int64;
  /** 用户名 */
  username: string;
  /** 昵称 */
  nickname: string;
  /** 头像 */
  avatar: string;
  /** 是否超管 */
  isSuperAdmin: boolean;
  /** 是否启用 */
  isActive: boolean;
  /** 角色 */
  roles: Int64[];
  /** 创建时间 */
  createTime: DateTime;
  /** 更新时间 */
  updateTime?: DateTime;
  /** 创建人 */
  creator: String;
  /** 更新人 */
  updater?: String;
}

/**
 * 查询管理员 列表
 */
@endpoint({
  path: '/adminUser/query',
  method: 'POST',
  tags: [
    'adminUser'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:user:read')")`
    ]
  }
})
class QueryAdminUser {
  @request
  request(
    @body() body: QueryAdminUserRequest
  ){}

  @response({status: 200})
  response(
    @body() body: QueryAdminUserResponse
  ){}
}

/**
 * 查询条件
 */
interface QueryAdminUserRequest {
  /** 用户名 */
  username?: string;
  /** 是否超管 */
  isSuperAdmin?: boolean;
  /** 页大小 */
  size: Int64;
  /** 当前页 */
  currentPage: Int64;
}

interface QueryAdminUserResponse extends ApiResult {
  data: QueryAdminUserData
}

interface QueryAdminUserData {
  /** 总数量 */
  totalElements: Int64;
  /** 总页数 */
  totalPages: Int64;
  /** 页大小 */
  size: Int64;
  /** 当前页 */
  currentPage: Int64;
  /** 元素内容 */
  elements: QueryAdminUserDataElement[]
}

interface QueryAdminUserDataElement {
  /** id */
  id: Int64;
  /** 用户名 */
  username: string;
  /** 昵称 */
  nickname: string;
  /** 头像 */
  avatar: string;
  /** 是否超管 */
  isSuperAdmin: boolean;
  /** 是否启用 */
  isActive: boolean;
  /** 角色 */
  roles: String;
  /** 创建时间 */
  createTime: DateTime;
  /** 更新时间 */
  updateTime?: DateTime;
  /** 创建人 */
  creator: String;
  /** 更新人 */
  updater?: String;
}

/**
 * 删除管理员
 */
@endpoint({
  path: '/adminUser/del',
  method: 'POST',
  tags: [
    'adminUser'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:user:delete')")`
    ]
  }
})
class DeleteAdminUser {
  @request
  request(
    @body() body: DeleteAdminUserRequest
  ){}

  @response({status: 200})
  response(
    @body() body: ApiResult
  ){}
}

interface DeleteAdminUserRequest {
  /** id */
  id: Int64;
}