import {body, endpoint, request, response, Int64, DateTime} from "spot-liangjihua";
import {ApiResult} from "../base-model";


/**
 * 新建 role
 */
@endpoint({
  path: '/role/create',
  method: 'POST',
  tags: [
    'role'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:role:create')")`
    ]
  }
})
class CreateRole {
  @request
  request(
    @body() body: CreateRoleRequest
  ){}

  @response({status: 200})
  response(
    @body() body: CreateRoleResponse
  ){}
}

interface CreateRoleRequest {
  /** 名称，仅用作占位示例，自行更换为其他实体类属性 */
  name: string;
}

interface CreateRoleResponse extends ApiResult {
  data: CreateRoleData
}

interface CreateRoleData {
  /** id */
  id: Int64;
}

/**
 * 更新 role
 */
@endpoint({
  path: '/role/update',
  method: 'POST',
  tags: [
    'role'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:role:update')")`
    ]
  }
})
class UpdateRole {
  @request
  request(
    @body() body: UpdateRoleRequest
  ){}

  @response({status: 200})
  response(
    @body() body: UpdateRoleResponse
  ){}
}

interface UpdateRoleRequest {
  /** id */
  id: Int64;
  /** 名称 */
  name: string;
}

interface UpdateRoleResponse extends ApiResult {
  data: UpdateRoleData
}

interface UpdateRoleData {
  /** id */
  id: Int64;
  /** 名称 */
  name: string;
}

/**
 * 读取 role
 */
@endpoint({
  path: '/role/read',
  method: 'POST',
  tags: [
    'role'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:role:read')")`
    ]
  }
})
class ReadRole {
  @request
  request(
    @body() body: ReadRoleRequest
  ){}

  @response({status: 200})
  response(
    @body() body: ReadRoleResponse
  ){}
}

interface ReadRoleRequest {
  /** id */
  id: Int64;
}

interface ReadRoleResponse extends ApiResult {
  data: ReadRoleData
}

interface ReadRoleData {
  /** id */
  id: Int64;
  /** 名称 */
  name: string;
}

/**
 * 查询 role 列表
 */
@endpoint({
  path: '/role/query',
  method: 'POST',
  tags: [
    'role'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:role:read')")`
    ]
  }
})
class QueryRole {
  @request
  request(
    @body() body: QueryRoleRequest
  ){}

  @response({status: 200})
  response(
    @body() body: QueryRoleResponse
  ){}
}

/**
 * 查询条件
 */
interface QueryRoleRequest {
  /** 角色名 */
  name?: string;
  /** 页大小 */
  size: Int64;
  /** 当前页 */
  currentPage: Int64;
}

interface QueryRoleResponse extends ApiResult {
  data: QueryRoleData
}

interface QueryRoleData {
  /** 总数量 */
  totalElements: Int64;
  /** 总页数 */
  totalPages: Int64;
  /** 页大小 */
  size: Int64;
  /** 当前页 */
  currentPage: Int64;
  /** 元素内容 */
  elements: QueryRoleDataElement[]
}

interface QueryRoleDataElement {
  /** id */
  id: Int64;
  /** 名称 */
  name: string;
  /** 创建时间 */
  createTime: DateTime;
  /** 更新时间 */
  updateTime?: DateTime;
  /** 创建人 */
  creator: string;
  /** 更新人 */
  updater?: string;
}

/**
 * 删除 role
 */
@endpoint({
  path: '/role/del',
  method: 'POST',
  tags: [
    'role'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:role:delete')")`
    ]
  }
})
class DeleteRole {
  @request
  request(
    @body() body: DeleteRoleRequest
  ){}

  @response({status: 200})
  response(
    @body() body: ApiResult
  ){}
}

interface DeleteRoleRequest {
  /** id */
  id: Int64;
}

/**
 * 分配角色权限 role
 */
@endpoint({
  path: '/role/updatePermission',
  method: 'POST',
  tags: [
    'role'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:role:update')")`
    ]
  }
})
class UpdatePermission {
  @request
  request(
    @body() body: UpdatePermissionRequest
  ){}

  @response({status: 200})
  response(
    @body() body: ApiResult
  ){}
}

interface UpdatePermissionRequest {
  /** id */
  id: Int64;
  /** 权限标识 */
  permissions: string[];
}

/**
 * 读取角色权限 role
 */
@endpoint({
  path: '/role/readPermission',
  method: 'POST',
  tags: [
    'role'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:role:read')")`
    ]
  }
})
class ReadPermission {
  @request
  request(
    @body() body: ReadPermissionRequest
  ){}

  @response({status: 200})
  response(
    @body() body: ReadPermissionResponse
  ){}
}

interface ReadPermissionRequest {
  /** id */
  id: Int64;
}

interface ReadPermissionResponse extends ApiResult {
  /** 角色权限 */
  data: string[];
}