export interface Resource {
  name: string;
  op: {
    [key: string]: Operation
  }
}

export interface Operation {
  name: string;
  code: string;
}

export function read(code: string): Operation {
  return {
    name: '查看',
    code
  }
}

export function create(code: string): Operation {
  return {
    name: '创建',
    code
  }
}

export function update(code: string): Operation {
  return {
    name: '修改',
    code
  }
}

export function del(code: string): Operation {
  return {
    name: '删除',
    code
  }
}
