#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.upms.mapper;

import ${package}.service.dto.QueryAdminUserDataElement;
import ${package}.service.dto.QueryAdminUserRequest;
import ${package}.upms.entity.UpmsUser;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Optional;

/**
 * <p>
 * 用户模块-管理员表 Mapper 接口
 * </p>
 *
 * @author yujiaxin
 * @since 2024-06-07
 */
public interface UpmsUserMapper extends BaseMapper<UpmsUser> {

    default Optional<UpmsUser> selectByUserName(String username) {
        return Optional.ofNullable(selectOne(Wrappers.<UpmsUser>lambdaQuery()
                .eq(UpmsUser::getUsername, username)));
    }

    List<QueryAdminUserDataElement> queryAdminUser(Page<QueryAdminUserDataElement> page, @Param("req") QueryAdminUserRequest req);
}
