#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.upms.service;

import ${package}.exception.BizException;
import ${package}.security.SecurityUtils;
import ${package}.service.dto.*;
import ${package}.upms.entity.UpmsAdminRole;
import ${package}.upms.entity.UpmsAdminRolePermission;
import ${package}.upms.mapper.UpmsAdminRoleMapper;
import ${package}.upms.mapper.UpmsAdminRolePermissionMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import ${package}.web.rest.RoleApiDelegate;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.time.LocalDateTime;
import java.util.List;

@Slf4j
@Service
@RequiredArgsConstructor
public class RoleService implements RoleApiDelegate {
    private final UpmsAdminRoleMapper upmsAdminRoleMapper;
    private final UpmsAdminRolePermissionMapper rolePermissionMapper;

    public QueryRoleData queryRole(QueryRoleRequest req) {
        Page<UpmsAdminRole> page = Page.of(req.getCurrentPage(), req.getSize());
        List<UpmsAdminRole> roles = upmsAdminRoleMapper.queryRole(page, req);
        return new QueryRoleData(
                page.getTotal(),
                page.getPages(),
                page.getSize(),
                page.getCurrent(),
                roles.stream().map(r -> {
                    var queryRoleDataElement = new QueryRoleDataElement(
                            r.getId(),
                            r.getName(),
                            r.getCreateTime(),
                            r.getCreator());
                    queryRoleDataElement.setUpdateTime(r.getUpdateTime());
                    queryRoleDataElement.setUpdater(r.getUpdater());
                    return queryRoleDataElement;
                }).toList()
        );
    }

    public UpdateRoleData updateRole(UpdateRoleRequest req) {
        UpmsAdminRole role = upmsAdminRoleMapper.selectById(req.getId());
        if (role == null) {
            throw new BizException("该角色不存在");
        }

        UpmsAdminRole upmsAdminRole = new UpmsAdminRole();
        upmsAdminRole.setId(req.getId());
        upmsAdminRole.setName(req.getName());
        upmsAdminRole.setUpdateTime(LocalDateTime.now());
        upmsAdminRole.setUpdater(SecurityUtils.getCurrentUserLogin().orElse("system"));
        upmsAdminRoleMapper.updateById(upmsAdminRole);
        return new UpdateRoleData(role.getId(), req.getName());
    }

    public CreateRoleData createRole(CreateRoleRequest createRoleRequest) {
        UpmsAdminRole upmsAdminRole = new UpmsAdminRole();
        upmsAdminRole.setName(createRoleRequest.getName());
        upmsAdminRole.setCreateTime(LocalDateTime.now());
        upmsAdminRole.setCreator(SecurityUtils.getCurrentUserLogin().orElse("system"));
        upmsAdminRoleMapper.insert(upmsAdminRole);
        return new CreateRoleData(upmsAdminRole.getId());
    }

    public void deleteRole(DeleteRoleRequest deleteRoleRequest) {
        upmsAdminRoleMapper.deleteById(deleteRoleRequest.getId());
    }

    public ReadRoleData readRole(ReadRoleRequest req) {
        UpmsAdminRole role = upmsAdminRoleMapper.selectById(req.getId());
        if (role == null) {
            throw new BizException("该角色不存在");
        }
        return new ReadRoleData(role.getId(), role.getName());
    }

    public List<String> readPermission(ReadPermissionRequest readPermissionRequest) {
        return rolePermissionMapper.selectPermissionByRoleId(readPermissionRequest.getId());
    }

    @Transactional
    public void updatePermission(UpdatePermissionRequest updatePermissionRequest) {
        rolePermissionMapper.deleteByRoleId(updatePermissionRequest.getId());
        List<UpmsAdminRolePermission> rolePermissions = updatePermissionRequest.getPermissions()
                .stream()
                .map(p -> {
                    UpmsAdminRolePermission upmsAdminRolePermission = new UpmsAdminRolePermission();
                    upmsAdminRolePermission.setPermission(p);
                    upmsAdminRolePermission.setRoleId(updatePermissionRequest.getId());
                    return upmsAdminRolePermission;
                })
                .toList();
        rolePermissionMapper.saveBatch(rolePermissions);
    }
}
