import {
  AdminUserResource,
  AdminRoleResource
} from '@permissions/admin/adminResources';

export default {
  path: '/adminManager',
  name: 'AdminManager',
  meta: {
    icon: 'ep:home-filled',
    title: '系统管理',
    rank: 6,
  },
  children: [
    {
      path: '/adminUser',
      name: 'AdminUser',
      component: () => import('@/views/admin/user/index.vue'),
      meta: {
        title: '管理员列表',
        roles: [AdminUserResource.op.read.code],
        showParent: true,
      },
    },
    {
      path: '/roles',
      name: 'roles',
      component: () => import('@/views/admin/role/index.vue'),
      meta: {
        title: '角色管理',
        roles: [AdminRoleResource.op.read.code],
        showParent: true,
      },
    },
  ],
} satisfies RouteConfigsTable;
