/**
 * CRUD 接口模板。
 * 新建实体类或数据库表后，可复制此文件，将 “XX” 修改对应的实体类名称即可。
 */
import {body, endpoint, request, response, Int64} from "spot-liangjihua";
import {ApiResult} from "./base-model";


/**
 * 新建 XX
 */
@endpoint({
  path: '/api/xx/create',
  method: 'POST',
  tags: [
    'xx'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:xx:create')")`
    ]
  }
})
class CreateXX {
  @request
  request(
    @body() body: CreateXXRequest
  ){}

  @response({status: 200})
  response(
    @body() body: CreateXXResponse
  ){}
}

interface CreateXXRequest {
  /** 名称，仅用作占位示例，自行更换为其他实体类属性 */
  name: string;
}

interface CreateXXResponse extends ApiResult {
  data: CreateXXData
}

interface CreateXXData {
  /** id */
  id: Int64;
}

/**
 * 更新 XX
 */
@endpoint({
  path: '/api/xx/update',
  method: 'POST',
  tags: [
    'xx'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:xx:update')")`
    ]
  }
})
class UpdateXX {
  @request
  request(
    @body() body: UpdateXXRequest
  ){}

  @response({status: 200})
  response(
    @body() body: UpdateXXResponse
  ){}
}

interface UpdateXXRequest {
  /** id */
  id: Int64;
  /** 名称 */
  name: string;
}

interface UpdateXXResponse extends ApiResult {
  data: UpdateXXData
}

interface UpdateXXData {
  /** id */
  id: Int64;
  /** 名称 */
  name: string;
}

/**
 * 读取 XX
 */
@endpoint({
  path: '/api/xx/read',
  method: 'POST',
  tags: [
    'xx'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:xx:read')")`
    ]
  }
})
class ReadXX {
  @request
  request(
    @body() body: ReadXXRequest
  ){}

  @response({status: 200})
  response(
    @body() body: ReadXXResponse
  ){}
}

interface ReadXXRequest {
  /** id */
  id: Int64;
}

interface ReadXXResponse extends ApiResult {
  data: ReadXXData
}

interface ReadXXData {
  /** id */
  id: Int64;
  /** 名称 */
  name: string;
}

/**
 * 查询 XX 列表
 */
@endpoint({
  path: '/api/xx/query',
  method: 'POST',
  tags: [
    'xx'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:xx:read')")`
    ]
  }
})
class QueryXX {
  @request
  request(
    @body() body: QueryXXRequest
  ){}

  @response({status: 200})
  response(
    @body() body: QueryXXResponse
  ){}
}

/**
 * 查询条件
 */
interface QueryXXRequest {
  /** id */
  id?: Int64;
  /** 页大小 */
  size: Int64;
  /** 当前页 */
  currentPage: Int64;
}

interface QueryXXResponse extends ApiResult {
  data: QueryXXData
}

interface QueryXXData {
  /** 总数量 */
  totalElements: Int64;
  /** 总页数 */
  totalPages: Int64;
  /** 页大小 */
  size: Int64;
  /** 当前页 */
  currentPage: Int64;
  /** 元素内容 */
  elements: QueryXXDataElement[]
}

interface QueryXXDataElement {
  /** id */
  id: Int64;
  /** 名称 */
  name: string;
}

/**
 * 删除 XX
 */
@endpoint({
  path: '/api/xx/del',
  method: 'POST',
  tags: [
    'xx'
  ],
  extension: {
    'x-operation-extra-annotation': [
      `@PreAuthorize("hasAuthority('admin:xx:delete')")`
    ]
  }
})
class DeleteXX {
  @request
  request(
    @body() body: DeleteXXRequest
  ){}

  @response({status: 200})
  response(
    @body() body: ApiResult
  ){}
}

interface DeleteXXRequest {
  /** id */
  id: Int64;
}