/**
 * 管理系统的资源
 */
import {Resource, read, create, update, del} from "../utils";
export const AdminUserResource = {
  name: '管理员',
  op: {
    read: read('admin:user:read'),
    create: create('admin:user:create'),
    update: update('admin:user:update'),
    delete: del('admin:user:delete')
  }
} as const satisfies Resource

export const AdminRoleResource =  {
  name: '角色',
  op: {
    read: read('admin:role:read'),
    create: create('admin:role:create'),
    update: update('admin:role:update'),
    delete: del('admin:role:delete')
  }
} as const satisfies Resource


export const AdminConfigResource =  {
  name: '系统配置',
  op: {
    read: read('admin:config:read'),
    update: update('admin:config:update'),
  }
} as const satisfies Resource

export default {
  AdminUserResource,
  AdminRoleResource,
  AdminConfigResource,
}