#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.openapi.generator;

import io.swagger.v3.oas.models.media.Schema;
import org.openapitools.codegen.*;
import org.openapitools.codegen.languages.SpringCodegen;
import org.openapitools.codegen.model.ModelMap;
import org.openapitools.codegen.model.OperationMap;
import org.openapitools.codegen.model.OperationsMap;
import org.openapitools.codegen.utils.ModelUtils;

import java.util.*;

public class ArkSpringCodegenGenerator extends SpringCodegen implements CodegenConfig {
    @Override
    public String getName() {
        return "spring";
    }

    @SuppressWarnings("rawtypes")
    @Override
    public OperationsMap postProcessOperationsWithModels(OperationsMap objs, List<ModelMap> allModels) {
        OperationMap operations = objs.getOperations();
        if (operations != null) {
            final List<CodegenOperation> ops = operations.getOperation();
            final Map<String, Schema> schemas = ModelUtils.getSchemas(this.openAPI);
            for (final CodegenOperation operation : ops) {
                replaceResponsesDataType(operation, schemas);
                replaceReturnDataType(objs, operation, schemas);
            }
        }
        return super.postProcessOperationsWithModels(objs, allModels);
    }

    @SuppressWarnings("rawtypes")
    private void replaceReturnDataType(OperationsMap objs, CodegenOperation operation, Map<String, Schema> schemas) {
        Object resultType = this.additionalProperties().getOrDefault("resultType", "Result");
        operation.vendorExtensions.put("x-result-type", resultType);
        if (operation.returnProperty != null) {
            findCodegenModel(operation.returnProperty.getComplexType(), schemas)
                    .ifPresent(model -> {
                        if (isSchemaMatch(model.vars)) {
                            Optional<CodegenProperty> varOp = findCodegenPropertyNamedData(model.vars);
                            if (varOp.isPresent()) {
                                // spring codegen 处理了所有名称中不包含 response 关键字的类型，自动添加了 @Valid 注解
                                // 在这里我们替换了默认的返回值，因此我们需要手动将 @Valid 再移除掉
                                String dataType = varOp.get().dataType.replace("@Valid", "");
                                if (varOp.get().isContainer) {
                                    operation.isMap = varOp.get().isMap;
                                    operation.returnContainer = varOp.get().containerTypeMapped;
                                    operation.isArray = varOp.get().isArray;
                                }
                                operation.returnType = dataType;
                                operation.returnProperty = varOp.get();
                                CodegenProperty itemVar = stripContainer(varOp.get());
                                if (!itemVar.isPrimitiveType) {
                                    objs.getImports().add(createImportMapping(schemas, itemVar));
                                }
                            } else {
                                operation.returnType = String.format("%s<Void>", resultType);
                                operation.vendorExtensions.put("x-return-void", true);
                                Map<String, String> im = new HashMap<>();
                                im.put("import", "java.lang.Void");
                                im.put("classname", "Void");
                                objs.getImports().add(im);
                            }
                        }
                    });
        }
    }

    @SuppressWarnings("rawtypes")
    private Optional<CodegenModel> findCodegenModel(String typeName, Map<String, Schema> schemas) {
        Schema schema = schemas.get(typeName);
        if (schema != null) {
            return Optional.ofNullable(fromModel(typeName, schema)) ;
        }
        return Optional.empty();
    }

    @SuppressWarnings("rawtypes")
    private void replaceResponsesDataType(CodegenOperation operation, Map<String, Schema> schemas) {
        Object resultType = this.additionalProperties().getOrDefault("resultType", "Result");
        final List<CodegenResponse> responses = operation.responses;
        if (responses != null) {
            for (final CodegenResponse resp : responses) {
                findCodegenModel(resp.getComplexType(), schemas)
                        .ifPresent(model -> {
                            if (isSchemaMatch(model.vars)) {
                                Optional<CodegenProperty> varOp = findCodegenPropertyNamedData(model.vars);
                                if (varOp.isPresent()) {
                                    // spring codegen 处理了所有名称中不包含 response 关键字的类型，自动添加了 @Valid 注解
                                    // 在这里我们替换了默认的返回值，因此我们需要手动将 @Valid 再移除掉
                                    String dataType = varOp.get().dataType.replace("@Valid", "");
                                    resp.dataType = String.format("%s<%s>", resultType, dataType);
                                } else {
                                    resp.dataType = String.format("%s<Void>", resultType);
                                }
                            }
                        });
            }
        }
    }

    @SuppressWarnings("rawtypes")
    private Map<String, String> createImportMapping(Map<String, Schema> schemas, CodegenProperty varData) {
        String propertySchema = schemas.keySet().stream()
                .filter(k -> toModelName(k).equals(varData.dataType))
                .findAny()
                .orElseThrow(() -> new RuntimeException(String.format("找不到属性：%s 对应的模型, dataType=%s",
                        varData.name, varData.dataType)));
        Schema schema = schemas.get(propertySchema);
        if (schema == null) {
            throw new RuntimeException(String.format("找不到属性：%s 对应的模型, dataType=%s",
                    varData.name, varData.dataType));
        }
        CodegenModel codegenModel = fromModel(propertySchema, schema);
        Map<String, String> im = new HashMap<>();
        im.put("import", toModelImport(codegenModel.classname));
        im.put("classname", codegenModel.classname);
        return im;
    }

    /**
     * “剥去” 外层容器类型，返回内部实际的模型类
     *
     * @param varData 代码生成类属性
     * @return 内部实际的模型类
     */
    private CodegenProperty stripContainer(CodegenProperty varData) {
        if (varData.isContainer) {
            return stripContainer(varData.items);
        }
        return varData;
    }

    /**
     * 检查属性列表是否匹配 resultType 的属性.
     *
     * @param vars 属性列表
     * @return 是否匹配
     */
    private boolean isSchemaMatch(List<CodegenProperty> vars) {
        String resultTypeFields = additionalProperties()
                .getOrDefault("resultTypeFields", "code|data|message")
                .toString();
        String[] fields = resultTypeFields.split("${symbol_escape}${symbol_escape}|");
        boolean hasVarCode = vars.stream().anyMatch(p -> p.name.equals(fields[0]));
        boolean hasVarData = vars.stream().anyMatch(p -> p.name.equals(fields[1]));
        boolean hasVarMsg = vars.stream().anyMatch(p -> p.name.equals(fields[2]));
        if (vars.size() == 3) {
            return hasVarCode && hasVarMsg && hasVarData;
        }
        if (vars.size() == 2) {
            return hasVarCode && hasVarMsg;
        }
        return false;
    }

    private Optional<CodegenProperty> findCodegenPropertyNamedData(List<CodegenProperty> vars) {
        return vars.stream()
                .filter(p -> p.name.equals("data"))
                .findAny();
    }

}
