#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.config;

import ${package}.queue.QueueService;
import ${package}.queue.impl.JavaQueueService;
import ${package}.queue.impl.RedissonQueueService;
import org.redisson.api.RedissonClient;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class DelayQueueConfig {

    @Profile("!dev")
    @Bean
    public QueueService redisQueueService(RedissonClient redissonClient) {
        return new RedissonQueueService(redissonClient);
    }

    @Profile("dev")
    @Bean
    public QueueService javaQueueService() {
        return new JavaQueueService();
    }
}
