#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.config;

import cn.hutool.core.util.ClassUtil;
import org.apache.ibatis.type.EnumTypeHandler;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class MyEnumTypeHandler<E extends Enum<E>> extends EnumTypeHandler<E> {
    private final Class<E> type;
    public MyEnumTypeHandler(Class<E> type) {
        super(type);
        this.type = type;
    }


    public E getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String s = rs.getString(columnName);
        return s == null ? null : ClassUtil.invoke(type.getName(),"fromValue", new Object[]{s});
    }

    public E getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String s = rs.getString(columnIndex);
        return s == null ? null : ClassUtil.invoke(type.getName(),"fromValue", new Object[]{s});
    }

    public E getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String s = cs.getString(columnIndex);
        return s == null ? null : ClassUtil.invoke(type.getName(),"fromValue", new Object[]{s});
    }
}
