#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.Nonnull;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.AbstractJackson2HttpMessageConverter;

public class VoidMessageConverter extends AbstractJackson2HttpMessageConverter {
    protected VoidMessageConverter(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    protected boolean supports(@Nonnull Class<?> clazz) {
        return void.class == clazz;
    }

    @Override
    public boolean canWrite(@Nonnull Class<?> clazz, MediaType mediaType) {
        return void.class == clazz;
    }
}
