#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.queue;

import java.util.List;

/**
 * 业务中常用的队列进行一个抽象。
 *
 * @author yujiaxin
 */
public interface QueueService {

    /**
     * 返回指定名称的延迟队列实例
     *
     * @param queueName 队列名称
     * @param <T>       队列元素的泛型
     * @return 延迟队列实例
     */
    <T> DelayedQueue<T> getDelayedQueue(String queueName);

    /**
     * 返回当前已初始化的所有队列
     *
     * @return 已初始化的队列列表，该列表是安全的，不会影响服务内部的队列。
     */
    List<DelayedQueue<?>> getAllQueue();
}
