#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.queue.impl;

import ${package}.queue.DelayedQueue;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.InitializingBean;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

import static java.util.concurrent.TimeUnit.NANOSECONDS;


public class JavaDelayedQueue<T> implements DelayedQueue<T>, InitializingBean {
    private final String queueName;
    private final DelayQueue<DelayQueueWrapper<T>> internalQueue;
    private final CopyOnWriteArrayList<Consumer<T>> consumers = new CopyOnWriteArrayList<>();

    public JavaDelayedQueue(String queueName) {
        this.queueName = queueName;
        this.internalQueue = new DelayQueue<>();
    }

    public record DelayQueueWrapper<T>(T obj, long time) implements Delayed {

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(time - System.nanoTime(), NANOSECONDS);
        }

        @Override
        public int compareTo(@Nonnull Delayed other) {
            if (other == this) {
                return 0;
            }
            long diff = getDelay(NANOSECONDS) - other.getDelay(NANOSECONDS);
            return (diff < 0) ? -1 : (diff > 0) ? 1 : 0;
        }

    }
    @Override
    public void offer(T ele, long delay, TimeUnit timeUnit) {
        internalQueue.offer(new DelayQueueWrapper<>(ele, System.nanoTime() + timeUnit.toNanos(delay)));
    }

    @Override
    public void offer(T ele, long delaySeconds) {
        offer(ele, delaySeconds, TimeUnit.SECONDS);
    }

    @Override
    public void register(Consumer<T> action) {
        consumers.add(action);
    }

    @Override
    public void consume() {
        try {
            while (!Thread.interrupted()) { // 循环消费，避免挤压消息
                DelayQueueWrapper<T> ele = internalQueue.take();
                for (Consumer<T> consumer : consumers) {
                    consumer.accept(ele.obj);
                }
            }
        } catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public boolean remove(@Nonnull T ele) {
        return internalQueue.removeIf(wrapper -> wrapper.obj.equals(ele));
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        new Thread(this::consume, "delayed-queue-" + queueName).start();
    }

}
