#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.queue.impl;

import ${package}.queue.DelayedQueue;
import ${package}.queue.QueueService;
import lombok.RequiredArgsConstructor;
import org.redisson.api.RedissonClient;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 基于redisson队列的实现
 *
 * @author yujiaxin
 */
@RequiredArgsConstructor
public class RedissonQueueService implements QueueService, InitializingBean {
    private final Map<String, DelayedQueue<?>> queueMap = new ConcurrentHashMap<>();
    private final RedissonClient redissonClient;

    @SuppressWarnings("unchecked")
    @Override
    public <T> DelayedQueue<T> getDelayedQueue(String queueName) {
        return (DelayedQueue<T>) queueMap.computeIfAbsent(queueName,
                (name) -> new RedissonDelayedQueue<T>(name, redissonClient));
    }

    @Override
    public List<DelayedQueue<?>> getAllQueue() {
        return new ArrayList<>(queueMap.values());
    }

    @Override
    public void afterPropertiesSet() {
    }
}
