#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.security;

import ${package}.upms.entity.UpmsUser;
import ${package}.upms.service.UserService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collections;

@Slf4j
@Component("userDetailsService")
@RequiredArgsConstructor
public class ArkUserDetailsService implements UserDetailsService {
    private final UserService userService;


    @Override
    @Transactional(readOnly = true)
    public UserDetails loadUserByUsername(final String login) {
        log.debug("Authenticating {}", login);
        return userService.getUserByUsername(login)
                .map(user -> createSpringSecurityUser(login, user))
                .orElseThrow(() -> new UsernameNotFoundException("用户不存在"));
    }

    private User createSpringSecurityUser(String lowercaseLogin, UpmsUser user) {
        ArkUser user1 = new ArkUser(user.getUsername(),
                user.getPassword(),
                user.isActivated(),
                user.isNotExpire(),
                true,
                true,
                Collections.emptyList());
        user1.setUserId(user.getId());
        user1.setUserType(user.getType());
        user1.setExpireTime(user.getExpireTime());
        return user1;
    }


}
