#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.security;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.ResourceUtils;

import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Slf4j
@Component
public class PermissionStore {
    private final Set<String> adminPermissions;
    private final ObjectMapper objectMapper;

    public PermissionStore(ObjectMapper objectMapper) throws IOException {
        this.objectMapper = objectMapper;
        adminPermissions = loadPermissions("classpath:admin-permission.json");
    }

    public Set<String> getAllAdminPermissions() {
        return this.adminPermissions;
    }

    public boolean isValidAdminPermission(String permissionCode) {
        return adminPermissions.contains(permissionCode);
    }

    private Set<String> loadPermissions(String resourceLocation) throws IOException {
        URL customResources = ResourceUtils.getURL(resourceLocation);
        Map<String, Resource> customResourcesMap = objectMapper.readValue(customResources, new TypeReference<>() {
        });
        return customResourcesMap.values().stream()
                .map(Resource::getOp)
                .flatMap(ops -> ops.values().stream())
                .map(Operation::getCode)
                .collect(Collectors.toUnmodifiableSet());
    }

    @Data
    static class Resource {
        private String name;
        private Map<String, Operation> op;
    }

    @Data
    static class Operation {
        private String name;
        private String code;
    }
}
