#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.security;

import ${package}.exception.BizException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.oauth2.jose.jws.MacAlgorithm;
import org.springframework.security.oauth2.jwt.Jwt;

import java.util.Optional;

public class SecurityUtils {
    public static final MacAlgorithm JWT_ALGORITHM = MacAlgorithm.HS512;

    public static final String AUTHORITIES_KEY = "auth";
    public static final String USERID_KEY = "user_id";
    public static final String USER_TYPE_KEY = "user_type";

    public static Optional<Authentication> getCurrentAuthentication() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        return Optional.ofNullable(securityContext.getAuthentication());
    }

    public static Optional<String> getCurrentUserLogin() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        return Optional.ofNullable(extractPrincipal(securityContext.getAuthentication()));
    }

    public static String getCurrentUserOrDefault() {
        return getCurrentUserLogin().orElse("system");
    }

    public static Optional<Integer> getCurrentUserType() {
        return getCurrentUser().map(Jwt::getClaims).map(claims -> claims.get(USER_TYPE_KEY).toString()).map(Integer::parseInt);
    }

    public static Optional<Long> getCurrentUserId() {
        return getCurrentUser().map(Jwt::getClaims).map(claims -> claims.get(USERID_KEY).toString()).map(Long::parseLong);
    }

    private static Optional<Jwt> getCurrentUser() {
        SecurityContext securityContext = SecurityContextHolder.getContext();
        Authentication authentication = securityContext.getAuthentication();
        if (authentication == null) {
            return Optional.empty();
        }
        return Optional.ofNullable((Jwt)authentication.getPrincipal());
    }

    private static String extractPrincipal(Authentication authentication) {
        if (authentication == null) {
            return null;
        } else if (authentication.getPrincipal() instanceof UserDetails springSecurityUser) {
            return springSecurityUser.getUsername();
        } else if (authentication.getPrincipal() instanceof Jwt jwt) {
            return jwt.getSubject();
        } else if (authentication.getPrincipal() instanceof String s) {
            return s;
        }
        return null;
    }

    public static Long getCurrentUserIdOrThrow() {
        return getCurrentUserId().orElseThrow(() -> new BizException("用户未登陆"));
    }
}
