#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.security;


import ${package}.upms.entity.UpmsUser;
import ${package}.upms.mapper.UpmsAdminRolePermissionMapper;
import ${package}.upms.mapper.UpmsUserMapper;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.Set;

@Component
@Slf4j
@RequiredArgsConstructor
public class UserPermissionService {
    private final UpmsUserMapper upmsUserMapper;
    private final UpmsAdminRolePermissionMapper rolePermissionMapper;
    private final PermissionStore permissionStore;
    public Set<String> loadPermissionsByUsername(String username) {
        return upmsUserMapper.selectByUserName(username)
                .map(this::loadPermissionsByUserType)
                .orElse(Collections.emptySet());
    }

    private Set<String> loadPermissionsByUserType(UpmsUser user) {
        if (user.isSuperAdmin()) {
            return permissionStore.getAllAdminPermissions();
        }
        if (user.isAdmin()) {
            return rolePermissionMapper.selectPermissionByUserId(user.getId());
        }
        return Collections.emptySet();
    }

}
