#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.upms.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serial;
import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Getter;
import lombok.Setter;

/**
 * <p>
 * 用户模块-管理员表
 * </p>
 *
 * @author yujiaxin
 * @since 2024-06-07
 */
@Getter
@Setter
@TableName("upms_user")
public class UpmsUser implements Serializable {

    @Serial
    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    /**
     * 用户名
     */
    private String username;

    /**
     * 密码
     */
    private String password;

    /**
     * 昵称
     */
    private String nickname;

    /**
     * 头像
     */
    private String avatar;

    /**
     * 用户类型: 0，超级管理员，1，管理员
     */
    private Integer type;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 创建人(管理员用户名)
     */
    private String creator;

    /**
     * 更新人(管理员用户名)
     */
    private String updater;

    /**
     * 是否激活
     */
    private Integer isActive;

    /**
     * 过期时间
     */
    private LocalDateTime expireTime;

    /**
     * 用户是否激活
     *
     * @return true 激活, false 未激活
     */
    public boolean isActivated() {
        return getIsActive() != null && getIsActive() == 1;
    }

    /**
     * 是否是管理员用户，这包含管理员超级管理员
     *
     * @return true 是管理员用户, false 不是管理员用户
     */
    public boolean isAdmin() {
        return type != null && (type == 1 || type == 0);
    }

    /**
     * 是否是管理员用户，这包含管理员超级管理员
     *
     * @return true 是管理员用户, false 不是管理员用户
     */
    public boolean isSuperAdmin() {
        return type != null && type == 0;
    }

    /**
     * 是否是客户
     *
     * @return true 是客户用户, false 不是客户用户
     */
    public boolean isCustomer() {
        return type != null && type == 2;
    }


    public void active() {
        setIsActive(1);
    }

    public void deactivate() {
        setIsActive(0);
    }

    public void setSuperAdmin() {
        setType(0);
    }
    public void setAdmin() {
        setType(1);
    }

    public void setCustomer() {
        setType(2);
    }

    public boolean isNotExpire() {
        return getExpireTime() == null || getExpireTime().isAfter(LocalDateTime.now());
    }

    public static boolean isSimpleAdmin(Integer type) {
        return type != null && type == 1;
    }
}
