#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.upms.mapper;

import ${package}.upms.entity.UpmsAdminRoleBind;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;

import java.util.List;

/**
 * <p>
 * 用户模块-管理员角色绑定表 Mapper 接口
 * </p>
 *
 * @author yujiaxin
 * @since 2024-06-07
 */
public interface UpmsAdminRoleBindMapper extends BaseMapper<UpmsAdminRoleBind> {

    default List<Long> selectRoleIdsByAdminId(Long adminId) {
        return selectObjs(Wrappers.<UpmsAdminRoleBind>lambdaQuery()
                .select(UpmsAdminRoleBind::getRoleId)
                .eq(UpmsAdminRoleBind::getAdminId, adminId));
    }

    default void deleteByAdminId(Long adminId) {
        delete(Wrappers.<UpmsAdminRoleBind>lambdaQuery()
                .eq(UpmsAdminRoleBind::getAdminId, adminId));
    }
}
