#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package}.upms.mapper;

import ${package}.upms.entity.UpmsAdminRolePermission;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.springframework.transaction.annotation.Transactional;

import java.util.Collection;
import java.util.List;
import java.util.Set;

/**
 * <p>
 * 用户模块-管理员角色权限表 Mapper 接口
 * </p>
 *
 * @author yujiaxin
 * @since 2024-06-07
 */
public interface UpmsAdminRolePermissionMapper extends BaseMapper<UpmsAdminRolePermission> {
    Log log = LogFactory.getLog(UpmsAdminRolePermissionMapper.class); //NOPMD - suppressed ProperLogger - Interface 中的属性都是常量

    Set<String> selectPermissionByUserId(@Param("adminId") Long id);

    List<String> selectPermissionByRoleId(@Param("roleId") Long roleId);

    @Transactional
    default void saveBatch(Collection<UpmsAdminRolePermission> values) {
        String sqlStatement = SqlHelper.getSqlStatement(UpmsAdminRolePermissionMapper.class, SqlMethod.INSERT_ONE);

        SqlHelper.executeBatch(UpmsAdminRolePermission.class, log, values, 1000,
                (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    default void deleteByRoleId(Long roleId) {
        delete(Wrappers.<UpmsAdminRolePermission>lambdaQuery()
                .eq(UpmsAdminRolePermission::getRoleId, roleId));
    }
}
