#set( $symbol_pound = '#' )
#set( $symbol_dollar = '$' )
#set( $symbol_escape = '\' )
package ${package};

import com.nimbusds.jose.jwk.source.ImmutableSecret;
import com.nimbusds.jose.util.Base64;
import lombok.SneakyThrows;
import org.junit.jupiter.api.Test;
import org.springframework.security.oauth2.jwt.*;

import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import java.time.Duration;
import java.time.Instant;

import static ${package}.security.SecurityUtils.JWT_ALGORITHM;

public class JwtExpireTest {

    @SneakyThrows
    @Test
    void testExpireJwt() {

        JwtClaimsSet claims = JwtClaimsSet.builder()
                .issuedAt(Instant.now())
                .expiresAt(Instant.now().plusSeconds(1L))
                .subject("test")
                .build();

        var jwtEncoder = new NimbusJwtEncoder(new ImmutableSecret<>(getSecretKey()));
        JwsHeader jwsHeader = JwsHeader.with(JWT_ALGORITHM).build();
        var token = jwtEncoder.encode(JwtEncoderParameters.from(jwsHeader, claims)).getTokenValue();


        var decoder = NimbusJwtDecoder.withSecretKey(getSecretKey()).macAlgorithm(JWT_ALGORITHM).build();
        decoder.setJwtValidator(new JwtTimestampValidator(Duration.ofSeconds(1L)));
        Jwt decode = decoder.decode(token);
        System.out.println(decode.getSubject());
        System.out.println(decode.getExpiresAt());
        System.out.println(decode.getExpiresAt().isBefore(Instant.now()));
    }


    private SecretKey getSecretKey() {
        byte[] keyBytes = Base64.from("NzliMWZlNzI4NmY2YWQyMTYyMGM5ZTk5MjA2NWM5YTg2YjliYjIzNzYyNmQxYWEwNDI1MTkzOTg0NmZiYTI0YmZiNGJmNDU0M2Q2MDA5NzNmMmI0MTBmNTJkOWRiNGZjMzQyYWUwMmJjYTYwZDhlNWU3MzY5MzI5YjE1OGUwNWY=").decode();
        return new SecretKeySpec(keyBytes, 0, keyBytes.length, JWT_ALGORITHM.getName());
    }
}
