/*
 * Decompiled with CFR 0.152.
 */
package cn.liberfree.sftp;

import cn.liberfree.sftp.SftpConfigration;
import cn.liberfree.sftp.SftpConnectionPool;
import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.util.List;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSftpConnectionPool
implements SftpConnectionPool {
    public static Logger logger = LoggerFactory.getLogger((String)DefaultSftpConnectionPool.class.getName());
    private SftpConfigration configration;
    private Boolean isActive = false;
    private Integer contActive = 0;
    private List<ChannelSftp> freeConnections = new Vector<ChannelSftp>();
    private List<ChannelSftp> activeConnections = new Vector<ChannelSftp>();
    private static ThreadLocal<ChannelSftp> threadLocal = new ThreadLocal();

    public DefaultSftpConnectionPool(SftpConfigration configration) {
        this.configration = configration;
        if (logger.isDebugEnabled()) {
            logger.debug("==========================================================");
            logger.debug("username:{}", (Object)this.configration.getUsername());
            logger.debug("password:{}", (Object)this.configration.getPassword());
            logger.debug("host:{}", (Object)this.configration.getHost());
            logger.debug("port:{}", (Object)this.configration.getPort());
            logger.debug("privateKey:{}", (Object)this.configration.getPrivateKey());
            logger.debug("poolName:{}", (Object)this.configration.getPoolName());
            logger.debug("minConnections:{}", (Object)this.configration.getMinConnections());
            logger.debug("maxConnections:{}", (Object)this.configration.getMaxConnections());
            logger.debug("initConnection:{}", (Object)this.configration.getInitConnection());
            logger.debug("connTimeOut:{}", (Object)this.configration.getConnTimeOut());
            logger.debug("maxActiveConnections:{}", (Object)this.configration.getMaxActiveConnections());
            logger.debug("ConnectionTimeOut:{}", (Object)this.configration.getConnectionTimeOut());
            logger.debug("isCurrentConnection:{}", (Object)this.configration.getCurrentConnection());
            logger.debug("isCheckPool:{}", (Object)this.configration.getCheckPool());
            logger.debug("lazyCheck:{}", (Object)this.configration.getLazyCheck());
            logger.debug("periodCheck:{}", (Object)this.configration.getPeriodCheck());
            logger.debug("==========================================================");
        }
        this.init();
        this.checkPool();
    }

    public ChannelSftp newChannelSftp() throws JSchException {
        JSch jsch = new JSch();
        if (this.configration.getPrivateKey() != null) {
            jsch.addIdentity(this.configration.getPrivateKey());
        }
        Session session = jsch.getSession(this.configration.getUsername(), this.configration.getHost(), this.configration.getPort());
        if (this.configration.getPassword() != null) {
            session.setPassword(this.configration.getPassword());
        }
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        session.setConfig(config);
        session.connect();
        Channel channel = session.openChannel("sftp");
        channel.connect();
        return (ChannelSftp)channel;
    }

    private void init() {
        try {
            for (int i = 0; i < this.configration.getInitConnection(); ++i) {
                ChannelSftp conn = this.newChannelSftp();
                if (conn == null) continue;
                this.freeConnections.add(conn);
                DefaultSftpConnectionPool defaultSftpConnectionPool = this;
                Integer n = defaultSftpConnectionPool.contActive;
                Integer n2 = defaultSftpConnectionPool.contActive = Integer.valueOf(defaultSftpConnectionPool.contActive + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ChannelSftp getConnection() {
        ChannelSftp conn = null;
        try {
            if (this.contActive < this.configration.getMaxActiveConnections()) {
                if (this.freeConnections.size() > 0) {
                    conn = this.freeConnections.get(0);
                    if (conn != null) {
                        threadLocal.set(conn);
                    }
                    this.freeConnections.remove(0);
                } else {
                    conn = this.newChannelSftp();
                }
            } else {
                this.wait(this.configration.getConnTimeOut());
                conn = this.getConnection();
            }
            if (this.isVaild(conn).booleanValue()) {
                this.activeConnections.add(conn);
                DefaultSftpConnectionPool defaultSftpConnectionPool = this;
                Integer n = defaultSftpConnectionPool.contActive;
                Integer n2 = defaultSftpConnectionPool.contActive = Integer.valueOf(defaultSftpConnectionPool.contActive + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conn;
    }

    public Boolean isVaild(ChannelSftp conn) {
        if (conn == null || conn.isClosed()) {
            return false;
        }
        return true;
    }

    public ChannelSftp getCurrentConnection() {
        ChannelSftp conn = threadLocal.get();
        if (!this.isVaild(conn).booleanValue()) {
            conn = this.getConnection();
        }
        return conn;
    }

    public void close(ChannelSftp conn) throws SftpException {
        if (this.isVaild(conn).booleanValue() && this.freeConnections.size() <= this.configration.getMaxConnections()) {
            this.freeConnections.add(conn);
            this.activeConnections.remove(conn);
            Integer n = this.contActive;
            Integer n2 = this.contActive = Integer.valueOf(this.contActive - 1);
            threadLocal.remove();
            try {
                this.notifyAll();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void destroy() {
        for (ChannelSftp conn : this.freeConnections) {
            try {
                if (!this.isVaild(conn).booleanValue()) continue;
                conn.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (ChannelSftp conn : this.activeConnections) {
            try {
                if (!this.isVaild(conn).booleanValue()) continue;
                conn.disconnect();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.isActive = false;
        this.contActive = 0;
    }

    public Boolean isActive() {
        return this.isActive;
    }

    public void checkPool() {
        if (this.configration.getCheckPool().booleanValue()) {
            new Timer().schedule(new TimerTask(){

                public void run() {
                    logger.debug("\u7a7a\u95f2\u8fde\u63a5\u6570" + DefaultSftpConnectionPool.this.freeConnections.size());
                    logger.debug("\u6d3b\u52a8\u8fde\u63a5\u6570" + DefaultSftpConnectionPool.this.activeConnections.size());
                    logger.debug("\u603b\u8fde\u63a5\u6570" + DefaultSftpConnectionPool.this.contActive);
                }
            }, this.configration.getLazyCheck(), (long)this.configration.getPeriodCheck());
        }
    }
}

