/*
 * Decompiled with CFR 0.152.
 */
package cn.lihongjie.image;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;

public class FastImageUtils {
    private static boolean isInitialized = false;
    private static RuntimeException initializationError = null;

    private static void init() {
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        String platform = FastImageUtils.detectPlatform(osName, osArch);
        String libraryName = FastImageUtils.getLibraryName(platform);
        try {
            FastImageUtils.loadLibraryFromResources(libraryName);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load Fast Image native library for platform: " + platform, e);
        }
    }

    private static String detectPlatform(String osName, String osArch) {
        String normalizedArch = osArch.contains("64") ? (osArch.contains("aarch") || osArch.contains("arm") ? "aarch64" : "x86_64") : (osArch.contains("86") ? "x86" : (osArch.contains("arm") || osArch.contains("aarch") ? "aarch64" : osArch));
        if (osName.contains("windows")) {
            return "windows-" + normalizedArch;
        }
        if (osName.contains("linux")) {
            return "linux-" + normalizedArch;
        }
        if (osName.contains("mac") || osName.contains("darwin")) {
            return "macos-" + normalizedArch;
        }
        throw new RuntimeException("Unsupported operating system: " + osName);
    }

    private static String getLibraryName(String platform) {
        switch (platform) {
            case "windows-x86_64": {
                return "fast_image-windows-x86_64.dll";
            }
            case "windows-aarch64": {
                return "fast_image-windows-aarch64.dll";
            }
            case "linux-x86_64": {
                return "libfast_image-linux-x86_64.so";
            }
            case "linux-aarch64": {
                return "libfast_image-linux-aarch64.so";
            }
            case "macos-x86_64": {
                return "libfast_image-macos-x86_64.dylib";
            }
            case "macos-aarch64": {
                return "libfast_image-macos-aarch64.dylib";
            }
        }
        throw new RuntimeException("Unsupported platform: " + platform);
    }

    private static void loadLibraryFromResources(String libraryName) throws IOException {
        String resourcePath = "/native/" + libraryName;
        try (InputStream in = FastImageUtils.class.getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new IOException("Native library not found in resources: " + resourcePath);
            }
            String tempFileName = "fast_image_" + System.currentTimeMillis();
            String fileExtension = FastImageUtils.getFileExtension(libraryName);
            Path tempFile = Files.createTempFile(tempFileName, fileExtension, new FileAttribute[0]);
            Files.copy(in, tempFile, StandardCopyOption.REPLACE_EXISTING);
            System.load(tempFile.toAbsolutePath().toString());
            tempFile.toFile().deleteOnExit();
        }
    }

    private static String getFileExtension(String libraryName) {
        int lastDot = libraryName.lastIndexOf(46);
        return lastDot >= 0 ? libraryName.substring(lastDot) : "";
    }

    private static void ensureInitialized() {
        if (!isInitialized) {
            if (initializationError != null) {
                throw new RuntimeException("Fast Image native library initialization failed", initializationError);
            }
            throw new RuntimeException("Fast Image native library not initialized");
        }
    }

    public static byte[] compress(byte[] imageBytes, int quality) {
        FastImageUtils.ensureInitialized();
        return FastImageUtils.compressNative(imageBytes, quality);
    }

    public static byte[] compressHigh(byte[] imageBytes) {
        return FastImageUtils.compress(imageBytes, 90);
    }

    public static byte[] compressMedium(byte[] imageBytes) {
        return FastImageUtils.compress(imageBytes, 60);
    }

    public static byte[] compressLow(byte[] imageBytes) {
        return FastImageUtils.compress(imageBytes, 30);
    }

    public static byte[] compressJpegFast(byte[] imageBytes, int quality) {
        FastImageUtils.ensureInitialized();
        return FastImageUtils.compressJpegFastNative(imageBytes, quality);
    }

    public static byte[] compressJpegFastHigh(byte[] imageBytes) {
        return FastImageUtils.compressJpegFast(imageBytes, 90);
    }

    public static byte[] compressJpegFastMedium(byte[] imageBytes) {
        return FastImageUtils.compressJpegFast(imageBytes, 60);
    }

    public static byte[] compressJpegFastLow(byte[] imageBytes) {
        return FastImageUtils.compressJpegFast(imageBytes, 30);
    }

    public static byte[] rotate(byte[] imageBytes, int angle) {
        FastImageUtils.ensureInitialized();
        return FastImageUtils.rotateNative(imageBytes, angle);
    }

    public static byte[] rotate90(byte[] imageBytes) {
        return FastImageUtils.rotate(imageBytes, 90);
    }

    public static byte[] rotate180(byte[] imageBytes) {
        return FastImageUtils.rotate(imageBytes, 180);
    }

    public static byte[] rotate270(byte[] imageBytes) {
        return FastImageUtils.rotate(imageBytes, 270);
    }

    public static String getPlatformInfo() {
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        String javaVersion = System.getProperty("java.version");
        try {
            String platform = FastImageUtils.detectPlatform(osName.toLowerCase(), osArch.toLowerCase());
            String libraryName = FastImageUtils.getLibraryName(platform);
            return String.format("Platform: %s (%s)\nArchitecture: %s\nJava: %s\nNative Library: %s\nInitialized: %s", osName, platform, osArch, javaVersion, libraryName, isInitialized);
        }
        catch (Exception e) {
            return String.format("Platform: %s\nArchitecture: %s\nJava: %s\nError: %s", osName, osArch, javaVersion, e.getMessage());
        }
    }

    public static boolean testLibrary() {
        try {
            FastImageUtils.ensureInitialized();
            byte[] testData = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
            FastImageUtils.compress(testData, 50);
            return false;
        }
        catch (RuntimeException e) {
            return e.getMessage().contains("compression failed") || e.getMessage().contains("Failed to load");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static native byte[] compressNative(byte[] var0, int var1);

    private static native byte[] compressJpegFastNative(byte[] var0, int var1);

    private static native byte[] rotateNative(byte[] var0, int var1);

    static {
        try {
            FastImageUtils.init();
            isInitialized = true;
        }
        catch (RuntimeException e) {
            initializationError = e;
        }
    }
}

