/*
 * Decompiled with CFR 0.152.
 */
package com.mapway.database2java.model.base;

import com.mapway.Util;
import com.mapway.database2java.database.AccessBase;
import com.mapway.database2java.database.IConnectionPool;
import com.mapway.database2java.model.base.Configure;
import com.mapway.database2java.model.itf.ISQLClause;
import com.mapway.database2java.model.itf.ISchema;
import com.mapway.database2java.model.schema.ITable;
import com.mapway.database2java.model.schema.Packages;
import com.mapway.database2java.model.schema.Sequences;
import com.mapway.database2java.model.schema.Tables;
import com.mapway.database2java.model.schema.View;
import com.mapway.database2java.model.schema.Views;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import javax.servlet.jsp.jstl.sql.Result;

public class NetSchemaBase
implements ISchema {
    public AccessBase a = null;
    Tables tables = null;
    Sequences sequences = null;
    Packages packages = null;
    Views views = null;
    ISQLClause sqlClause = null;
    Configure m_configure = null;
    Object[][] pks = null;
    String copyright = "\r\n<pre>\r\n\r\n           =============================================================\r\n           -   ____ _  _ ____ _  _ ____  _ _ ____ _  _ ____ _  _ ____  -\r\n           -    __] |__| |__| |\\ | | __  | | |__| |\\ | [__  |__| |___  -\r\n           -   [___ |  | |  | | \\| |__| _| | |  | | \\| ___] |  | |___  -\r\n           -           http://hi.baidu.com/zhangjianshe                -\r\n           =============================================================\r\n\r\n</pre>\r\n";

    public NetSchemaBase(IConnectionPool pool, Configure configure) {
        this.a = new AccessBase(pool);
        this.tables = new Tables();
        this.sequences = new Sequences();
        this.packages = new Packages();
        this.views = new Views();
        this.m_configure = configure;
    }

    @Override
    public boolean fetchSchema() {
        try {
            Result r = this.a.execute(this.getSQLClause().getPKSQL());
            this.pks = r.getRowsByIndex();
            return true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return true;
        }
    }

    public String getHeader() {
        return this.copyright;
    }

    public void setSQLClause(ISQLClause c) {
        this.sqlClause = c;
    }

    public Configure getConfigure() {
        return this.m_configure;
    }

    public boolean isPK(String tn, String cn) {
        boolean b = false;
        for (int i = 0; i < this.pks.length; ++i) {
            String tna = (String)this.pks[i][0];
            String cna = (String)this.pks[i][1];
            if (!tna.equals(tn) || !cna.equals(cn)) continue;
            b = true;
            break;
        }
        return b;
    }

    public ISQLClause getSQLClause() {
        return this.sqlClause;
    }

    @Override
    public Tables getTables() {
        return this.tables;
    }

    public Sequences getSequences() {
        return this.sequences;
    }

    public Packages getPackages() {
        return this.packages;
    }

    @Override
    public Views getViews() {
        return this.views;
    }

    public Object[][] getPKS() {
        return this.pks;
    }

    public void writeToFile(String path, String fn, String s) {
        File file = new File(path);
        if (!file.exists()) {
            file.mkdirs();
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(path + "\\" + fn);
            fw.write(s);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String exportJSONTools(Configure conf) {
        StringBuilder sb = new StringBuilder();
        this.out(sb, this.getCopyright());
        this.writeJSONTools(sb, conf);
        this.writeToFile(conf.getNetFilePath(), "JSONHelper.cs", sb.toString());
        return "";
    }

    private void writeJSONTools(StringBuilder sb, Configure conf) {
        StringBuilder sb1 = Util.readFromFile(new File("d:\\workspace2008\\database2java4\\src\\template\\json.txt"));
        String s = sb1.toString();
        s = s.replace("${package}", conf.getPackage());
        sb.append(s);
    }

    public void out(StringBuilder sb, String s) {
        sb.append(s + "\r\n");
    }

    @Override
    public String exportTable(ITable table, Configure conf) {
        return null;
    }

    @Override
    public void exportPoolInterface(Configure conf) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCopyright());
        this.out(sb, "namespace " + conf.getPackage() + "{");
        this.out(sb, "\tusing System.Data.OleDb;");
        this.out(sb, "\tpublic interface IConnectionPool {");
        this.out(sb, "\t\t OleDbConnection getConnection();");
        this.out(sb, "\t\t void releaseConnection(OleDbConnection con);");
        this.out(sb, "\t}");
        this.out(sb, "}");
        this.writeToFile(conf.getNetFilePath(), "IConnectionPool.cs", sb.toString());
    }

    @Override
    public void exportExecuteResult(Configure conf) {
        System.out.println("Export ExecuteResult.....");
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCopyright());
        this.out(sb, "package " + conf.getPackage() + ";\r\n");
        this.out(sb, "import java.sql.Connection;");
        this.out(sb, "import java.sql.ResultSet;");
        this.out(sb, "import java.sql.SQLException;");
        this.out(sb, "import java.sql.Statement;");
        this.out(sb, "public class ExecuteResult {");
        this.out(sb, "public ResultSet result;");
        this.out(sb, "public Statement statement;");
        this.out(sb, "Connection       con;");
        this.out(sb, "IConnectionPool  pool;");
        this.out(sb, "/**");
        this.out(sb, "* \ufffd\u01f5\ufffd\ufffd\ufffd\ufffd\ufffd\ufffd \ufffd\ufffd\ufffd\ufffd dispose \ufffd\u0377\ufffd\ufffd\ufffd\u0534");
        this.out(sb, "* ");
        this.out(sb, "* @param rs");
        this.out(sb, "* @param stm");
        this.out(sb, "*/");
        this.out(sb, "public ExecuteResult(IConnectionPool pool, Connection con, ResultSet rs,");
        this.out(sb, "Statement stm) {");
        this.out(sb, "this.con = con;");
        this.out(sb, "this.pool = pool;");
        this.out(sb, "result = rs;");
        this.out(sb, "statement = stm;");
        this.out(sb, "}");
        this.out(sb, "public void dispose()");
        this.out(sb, "{");
        this.out(sb, "try");
        this.out(sb, "{");
        this.out(sb, "if (result != null )");
        this.out(sb, "{");
        this.out(sb, "result.close();");
        this.out(sb, "result = null;");
        this.out(sb, "}");
        this.out(sb, "if (statement != null )");
        this.out(sb, "{");
        this.out(sb, "statement.close();");
        this.out(sb, "statement = null;");
        this.out(sb, "}");
        this.out(sb, "} catch (SQLException e)");
        this.out(sb, "{");
        this.out(sb, "e.printStackTrace();");
        this.out(sb, "} finally");
        this.out(sb, "{");
        this.out(sb, "if (this.pool != null)");
        this.out(sb, "{");
        this.out(sb, "this.pool.releaseConnection(con);");
        this.out(sb, "}");
        this.out(sb, "}");
        this.out(sb, "}");
        this.out(sb, "/**");
        this.out(sb, "* \ufffd\ufffd\u0221\u05b4\ufffd\u0435\u013d\ufffd\ufffd");
        this.out(sb, "* ");
        this.out(sb, "* @return");
        this.out(sb, "*/");
        this.out(sb, "public ResultSet getResultSet()");
        this.out(sb, "{");
        this.out(sb, "return this.result;");
        this.out(sb, "}");
        this.out(sb, "}");
        this.writeToFile(conf.getNetFilePath(), "ExecuteResult.cs", sb.toString());
    }

    @Override
    public void exportAccessBase(Configure conf) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getCopyright());
        StringBuilder sb1 = Util.readFromFile(new File("d:\\workspace2008\\database2java4\\src\\template\\accessbase.txt"));
        String s = sb1.toString();
        s = s.replace("${package}", conf.getPackage());
        sb.append(s);
        this.writeToFile(conf.getNetFilePath(), "AccessBase.cs", sb.toString());
        sb = new StringBuilder();
        sb.append(this.getCopyright());
        sb1 = Util.readFromFile(new File("d:\\workspace2008\\database2java4\\src\\template\\MyPool.txt"));
        s = sb1.toString();
        s = s.replace("${package}", conf.getPackage());
        sb.append(s);
        this.writeToFile(conf.getNetFilePath(), "MyPool.cs", sb.toString());
    }

    @Override
    public String getCopyright() {
        return null;
    }

    @Override
    public void exportViews(View at, Configure confTable) {
    }

    @Override
    public void exportProcedures(Configure confProcedure) {
    }

    public String findPrevPath(String path) {
        int index = path.lastIndexOf(46);
        if (index >= 0) {
            return path.substring(0, index);
        }
        return "";
    }

    @Override
    public void exportSequence(Configure conf) {
    }

    @Override
    public void exportSpringConfigure(Configure conf) {
    }

    @Override
    public void exportDwrConfigure(Configure conf) {
    }

    @Override
    public void exportGwtModule(Configure conf) {
    }

    @Override
    public void exportJavaBean(Configure conf) {
    }
}

